<?php

namespace App\Http\Controllers;

use App\Http\Requests\LoginRequest;
use App\Mail\SendEmail;
use App\Models\Auth_2fa;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;

class AuthController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if($this->checkSession()){
            return redirect()->route('dashboard');
        }

        if(Session::has('auth_2fa')){            
            return redirect()->route('verify');
        }

        return view('home.login');
    }

    

    public function logout(Request $request){
        self::InsertLogs('Saiu da aplicação.');
        //DB::table('users')->where('id', self::systemId())->update(['active' => 0]);    
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('index');
    }
   
    public function forgetSession(){
        Session::forget('expiration');
        Session::forget('auth_2fa');
        Session::forget('email_2fa');
        Session::forget('pass_2fa');
    }

    private function createOtp($otp, $email, $password){
        $expiration = Carbon::now()->addMinutes(10);                   
        Session::put('expiration', $expiration);
        Session::put('auth_2fa', true);
        Session::put('email_2fa', $email);
        Session::put('pass_2fa', $password);    
        Auth_2fa::create([
            'email' => $email,
            'otp' => $otp,
            'expiration' => $expiration
        ]);
    }

    public function login(LoginRequest $request)
    {
        
        $request->validate([
            'email' => ['required','email'],
            'password' => ['required']
        ],[
            'email.required' => 'O email é obrigatório',
            'email.email' => 'Digite um email válido',
            'password.required' => 'A senha é obrigatória'
        ]);

        $email = trim($request->input('email'));
        $password = trim($request->input('password'));

        $user = User::where('email', $email)->first();

        if ($user) {
            if ($user->status_user === '0') {
                // Usuário bloqueado
                return redirect()->back()->with(['error' => 'Utilizador bloqueado.']);
            }

            if(password_verify($password, $user->password)){
                if($user->auth_2fa){  
                    $auth = Auth_2fa::where('email',operator: $email)->where('status', '1')->first();
                    $user = User::where('email',operator: $email)->first();
                    $otp = implode(self::generatedNumber());
                    if($auth){
                        if (Carbon::now()->gt($auth->expiration)){
                            $auth->status = 0;
                            $auth->save();
                            $this->createOtp($otp, $email, $password);                             
                        }                        
                    }else{
                        $this->createOtp($otp, $email, $password);
                    }      
                    $msg = 
                        "
                        <p>Aqui está o seu código de verificação de dois fatores para acessar a sua conta:</p>
                        <p>Código : <strong>".$otp."</strong></p>
                        <p>Este código é válido por 10 minutos. Por favor, não compartilhe este código com ninguém.</p>
                        <p>Se você não solicitou este código, por favor, alguém deve estar tentando acessar a sua conta, altere a sua palavra passe.</p>
                        ";
                    self::sendEmail($email, $user->name, 'Autenticação', $msg);     
                    return redirect()->route('verify');
                }
            }

            if (Auth::attempt(['email' => $email, 'password' => $password, 'status_user' => '1'])) {
                self::InsertLogs('Entrou na aplicação.');
                return redirect()->intended('dashboard');
            }
        }

        // Autenticação falhou
        return redirect()->back()->with(['error' => 'E-mail ou senha inválida.']);
    }

    public function auth_2fa(){
        if(Session::has('auth_2fa')){
            
            if (Carbon::now()->gt(Session::get('expiration'))) {
                $auth = Auth_2fa::where('email',Session::get('email_2fa'))
                                                                ->where('status', '1')
                                                                ->first();
                if($auth){
                    $auth->status = 0;
                    $auth->save();   
                }
                $this->forgetSession();
                return redirect()->route('expire');
            }
            return view('home.verify');
        }
        return redirect()->route('login');
    }

    public function otp_check(Request $request){
        if(Session::has('auth_2fa')){
            define('EMAIL', Session::get('email_2fa'));
            if (Carbon::now()->gt(Session::get('expiration'))) {
                $auth = Auth_2fa::where('email',operator: EMAIL)
                                                                ->where('status', '1')
                                                                ->first();
                if($auth){
                    $auth->status = 0;
                    $auth->save();   
                }
                $this->forgetSession();
                return redirect()->route('expire');
            }
            
            $auth = Auth_2fa::where('email', EMAIL)
                                                            ->where('otp',$request->input('otp'))
                                                            ->where('status',operator: 1)->first();

            if(!$auth) return redirect()->route('login');

            if($auth->otp == $request->input('otp')){
                if (Auth::attempt(['email' => EMAIL, 'password' => Session::get('pass_2fa')])) {
                    $this->forgetSession();
                    $auth->status = 0;
                    $auth->save();
                    self::InsertLogs('Entrou na aplicação.');
                    return redirect()->intended('dashboard');
                }
            }
            return redirect()->back()->with(['error' => 'Código inválido!']);
        }
        
        return redirect()->route('login');
    }
}
