<?php

namespace App\Http\Controllers;

use App\Models\Configuration;
use App\Models\Social;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use PHPUnit\Metadata\Uses;

class ConfigurationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('admin.system.profile', ['user' => Auth::user(), 'level'=>self::Level()]);
    }

    public function updateProfile(Request $request)
    {
        try{

            $user = User::find(self::systemId());            

            if(!$user):
                return redirect()->back()->with(['status'=> 'error','msg'=> "Nenhum utilizador encontrado"]);
            endif;

            $file_name = 'default';
            $file = '';
            if(!empty($request->file('thumb'))){
                $allowedExtensions = ['heic', 'png', 'jpg'];
                $file = $request->file('thumb');
                $file_extension = $file->getClientOriginalExtension();  
                if (!in_array($file_extension, $allowedExtensions)){
                    return redirect()->back()->withInput()->withErrors(['status' => 'error', 'msg' => 'Seleciona somente ficheiros [heic, png, jpg]']);
                }
                $file_name = time() . '_' . $file->getClientOriginalName();          
                //$file->storeAs('avatar', $file_name, 'public'); 
            }
            
            $user->update([
                'name' => $request->input('name'),
                'thumb' => (empty($request->file('thumb'))) ? $user->thumb : $file_name,
            ]);

            if(!empty($request->file('thumb'))){
                Storage::disk('public')->put('avatar/' . $file_name, file_get_contents($file));
            } 
            return redirect()->back()->with(['status'=> 'success','msg'=> "Dados actualizados com sucesso"]);
        }catch(Exception $e){
            return redirect()->back()->with(['status'=> 'error','msg'=> "Não foi posível actualizar os dados ".$e->getMessage()]);
        }
    }

    public function password(Request $request)
    {
        try{
            $user = User::find(self::systemId());

            $request->validate([
                    'password' => 'required|string',
                    'old' => 'required|string'
                ],[
                    'password.required' => 'Digite a senha antiga',
                    'old.required' => 'Digite a nova senha'
                ]);

            $password = trim($request->input('password'));
            $password2 = trim($request->input('old'));

            if (!Hash::check($password2, $user->password)) {
                return redirect()->back()->with(['status'=> 'error', 'msg' => 'A palavra passe antiga digitada está errada']);
            }

            if ($password===$password2) {
                return redirect()->back()->with(['status'=> 'error', 'msg' => 'A nova palavra passe deve ser diferente da antiga.']);
            }

            $user->update([
                'password' => bcrypt($password)
            ]);

            return redirect()->back()->with(['status'=> 'success','msg'=> "Palavra passe actualizada com sucesso"]);
        }catch(Exception $e){
            return redirect()->back()->with(['status'=> 'error','msg'=> "Não foi posível actualizar a palavra passe"]);
        }
    }

    public function authentication(Request $request)
    {
        try{
            $filteredId = self::systemId();
            $user = User::find($filteredId);

            if (!$user || is_null($filteredId)) {
                return redirect()->back()->with(['status' => 'error', 'msg' => 'Este utilizador não existe']);
            }

            $user->auth_2fa = ($request->input('auth_2fa')) ? 1 : 0;
            $user->save();
            self::InsertLogs(($request->input('auth_2fa')==1) ? "[$user->name - $user->email], activou autenticação em 2 factores na sua conta ":"[$user->name - $user->email], desactivou a autenticação em 2 Factores");
            return redirect()->back()->with(['status' => 'success', 'msg' => ($request->input('auth_2fa')) ? 'Autetincação em 2 factores activada com sucesso.' : 'Autenticação em 2 factores desactivada com sucesso.']);

        } catch (\Exception $e) {
            return redirect()->back()->with(['status' => 'error', 'msg' => "Não foi possivel efectuar a operação, tente novamente."]);
        } 
    }

    public function socialMidia(Request $request){
        try {
            $request->validate([
               'social'  => 'required',
               'name' => 'required',
               'link' => 'required'
            ],[
                'social.required' => 'É obrigatório informar a rede social',
                'name.required' => 'É obrigatório informar o nome do perfil',
                'link.required' => 'É obrigatório informar o link'
            ]);

            Social::create($request->all());
            return redirect()->back()->with(['status' => 'success', 'msg' => 'Rede social registada com sucesso!']);
        } catch (\Exception $e) {
            return redirect()->back()->with(['status' => 'error', 'msg' => 'Não foi possível registar esta rede social.'.$e->getMessage()]);
        }
    }

    public function socialMidiaAll(Request $request){

    }

    public function destroySocialMidia(int $id)
    {        
        try{
            $filteredId = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if(is_null($filteredId)) return redirect()->back()->with(['status' => 'error', 'msg' => 'Contacto não encontrado.']);
            
            $social = DB::table('social_midia')
            ->where('idsocial_midia', '=', $filteredId)
            ->first();

            if (!$social) {
                return redirect()->back()->with(['status' => 'error', 'msg' => 'Contacto não encontrado.']);
            }

            // Excluir o registro
            DB::table('social_midia')
            ->where('idsocial_midia', '=', $filteredId)
            ->delete();
            return redirect()->back()->with(['status' => 'success', 'msg' => 'Contacto eliminado com sucesso.']);

        }catch(Exception $e) {
            return redirect()->back()->with(['status' => 'error', 'msg' => 'Não foi possível eliminar este contacto. id='.$id." | ".$e->getMessage()]);            
        }    
    }

}
