<?php

namespace App\Http\Controllers;

use App\Mail\Contact;
use App\Models\Social;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {        
        return view('home.contact', ['data' => Social::All()]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $mail = Mail::to('info@kambaanimation.com','Kamba Animation')->send(new Contact([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'message' => $request->input('message'),
            'ip' => $request->ip()
        ]));
        if($mail){
            return redirect()->back()->with(['status' => 'success','msg'=>'Mensagem enviada, entraremos em contacto!']);
        }
        return redirect()->back()->with(['status' => 'error','msg'=>'Não foi possível enviar a mensagem!']);
    }

}
