<?php

namespace App\Http\Controllers;

use App\Mail\SendEmail;
use App\Models\Logs;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function checkSession(){
        return Auth::check();
    }

    public static function dataUser(){
        return Auth::user(); 
    }

    public static function Level(){
        switch(self::dataUser()->level){
            case 10: return "Master";
            case 11: return "Administrador(a)";
            case 12: return "Normal";
        }
    }

    public static function systemId(){
        return Auth::user()->id;
    }

    public static function InsertLogs($details){
        Logs::create([
            'user' => self::dataUser()['name'].' ['.self::dataUser()['email'].']',
            'operation' => $details
        ]);        
    }

    public static function generatePassword() {
        $maiusculas = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $minusculas = 'abcdefghijklmnopqrstuvwxyz';
        $numeros = '0123456789';
        $simbolos = '!@#$%^&*()-_+=<>?';

        // Pelo menos um de cada conjunto
        $senha = $maiusculas[rand(0, 25)] . $minusculas[rand(0, 25)] . $numeros[rand(0, 9)] . $simbolos[rand(0, 17)];

        // Completar com caracteres aleatórios
        $caracteres = $maiusculas . $minusculas . $numeros . $simbolos;
        $tamanhoSenha = 6;

        for ($i = 4; $i < $tamanhoSenha; $i++) {
            $senha .= $caracteres[rand(0, strlen($caracteres) - 1)];
        }

        // Embaralhar a senha para garantir aleatoriedade
        $senhaEmbaralhada = str_shuffle($senha);

        return $senhaEmbaralhada;
    }

    public static function Time($dataCriacao) {
        $hoje = Carbon::now();
        $diferencaMinutos = $dataCriacao->diffInMinutes($hoje);
        $diferencaHoras = $dataCriacao->diffInHours($hoje);
        $diferencaDias = $dataCriacao->diffInDays($hoje);
        $diferencaMeses = $dataCriacao->diffInMonths($hoje);
        $diferencaAnos = $dataCriacao->diffInYears($hoje);

        if($diferencaMinutos < 60) {
            return 'Há ' . $diferencaMinutos . ' minuto(s)';
        } elseif($diferencaHoras < 24) {
            return 'Há ' . $diferencaHoras . ' hora(s)';
        } elseif($dataCriacao->isToday()) {
            return 'Hoje';
        } elseif($diferencaDias < 30) {
            return 'Há ' . $diferencaDias . ' dia(s)';
        } elseif($diferencaDias >= 30 && $diferencaAnos < 1) {
            return 'Há ' . $diferencaMeses . ' mês(es)';
        } else {
            return 'Há ' . $diferencaAnos . ' ano(s)';
        }
    }

    public static function generatedNumber() {
        $numbers = [];
    
        for ($i = 0; $i < 4; $i++) {
            $numbers[] = rand(0, 9); // Gera um número aleatório entre 0 e 9
        }
    
        return $numbers;
    }    

    public static function sendEmail($email, $name, $subject,$msg){
        Mail::to($email,$name)->send(new SendEmail([
            'subject' => $subject,
            'name_2' => $name,
            'name' => 'Kamba Animation',
            'email' => "geral@kambaanimation.com",
            'msg' => $msg
        ]));
    }

}
