<?php

namespace App\Http\Controllers;

use App\Models\File;
use App\Models\Project;
use App\Models\System;
use App\Models\Team;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MainController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $projects = Project::orderBy('idProject','DESC')->get();       
        return view('home.home',['data'=>$projects]);
    }

    public function reset()
    {
        if($this->checkSession()){ return redirect()->route('dashboard'); }
        return view('home.reset');
    }

    public function works()
    {
        $works = Project::orderBy('idProject', 'DESC')
                                    ->get();
        $categories = Project::select('projects.category')
        ->distinct()
        ->get();
        return view('home.trabalhos',['data'=>$works, 'categories'=>$categories]);
    }

    public function categoriesWork(string $category)
    {
        $filteredCategory = htmlspecialchars($category, ENT_QUOTES, 'UTF-8');
        $works = Project::where('category', $filteredCategory)
                                ->orderBy('idProject', 'DESC')
                                ->get();
        return view('home.trabalhosCategorias',['data'=>$works]);
    }

    public function work(string $category)
    {
        $filteredCategory = htmlspecialchars($category, ENT_QUOTES, 'UTF-8');
        $project = Project::where('name_project', $filteredCategory)->first();
        $files = File::select('files.*')
        ->join('projects', 'projects.idProject', '=', 'files.project_id')
        ->where('projects.name_project', '=', $filteredCategory)
        ->get();
        return view('home.trabalho', ['data' => $files, 'project' => $project]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function resetar(Request $request)
    {
        
    }

    public function about()
    {            
        $about = System::find(1);
        $images = DB::table('images')->get();
        return view('home.about',['about' => $about,'team'=>Team::all(), 'images' => $images]);
    }
}
