<?php

namespace App\Http\Controllers;

use App\Mail\SendNewsletter;
use App\Models\Logs;
use App\Models\Newsletter;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class NewsletterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('admin.newsletter',['data'=>Newsletter::orderBy('id','DESC')->get()]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $request->validate([
                'email' => 'email|required'
            ],[
                'email.email' => 'Digite um email válido.',
                'email.required' => 'É obrigatório digitar um email válido.',
            ]);

            $exist = Newsletter::where('email', $request->input('email'))->first();

            if($exist){
                if($exist->status==1){
                    return redirect()->back()->with(['status' => 'error','msg'=>'Este e-mail já está inscrito.']);
                }
                $exist->update(['status'=>'1']);
                Logs::create([
                    'user' => $request->input('email'),
                    'operation' => 'reactivou a sua subscrição de newsletter.'
                ]);
                $this->send($request->input('email'),'Subcrição Newsleeter!', null, null, null, null, null, null);  
                return redirect()->back()->with(['status' => 'success','msg'=>'Subscrição feita com sucesso.']);
            }else{
                $newsleeter = new Newsletter([
                    'email' => trim($request->input('email'))
                ]);
                $newsleeter->save();
                Logs::create([
                    'user' => $request->input('email'),
                    'operation' => 'Subscreveu ao newsleeter!'
                ]);
            }
            $this->send($request->input('email'),'Subcrição Newsleeter!', null, null, null, null, null);            
            return redirect()->back()->with(['status' => 'success','msg'=>'Subscrição feita com sucesso.']);
        }catch(Exception $e){
            return redirect()->back()->with(['status' => 'error','msg'=>'Não foi possível fazer a subscrição '.$e->getMessage()]);
        }    
    }

  /**
     * Update the specified resource in storage.
     */
    public function update(string $email)
    {
        try{            
            $filteredCategory = filter_var($email, FILTER_SANITIZE_EMAIL);
            $newsletter = Newsletter::where('email', $filteredCategory)->first();            

            if (!$newsletter) {
                return redirect()->route('index')->with(['status' => 'error', 'msg' => 'Este e-mail não existe']);
            }

            $newsletter->update([
                'status' => '0'
            ]);

            Logs::create([
                'user' => $email,
                'operation' => 'Cancelou a sua subscrição'
            ]);
            return redirect()->route('index')->with(['status' => 'success', 'msg' => 'Subscrição cancelada.']);

        } catch (Exception $e) {
            return redirect()->route('index')->with(['status' => 'error', 'msg' => "Não foi possivel efectuar a operação, tente novamente."]);
        } 
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(int $id)
    {        
        try{
            $filteredId = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            $newsletter = Newsletter::find($id);

            if (!$newsletter || is_null($filteredId)) {
                return redirect()->back()->with(['status' => 'error', 'msg' => 'Este email não existe']);
            }

            self::InsertLogs("Eliminou o email $newsletter->email do newsletter");
            $newsletter->delete();
            return redirect()->back()->with(['status' => 'success', 'msg' => 'E-mail eliminado.']);
            
        }catch(Exception $e) {
            return redirect()->back()->with(['status' => 'error', 'msg' => 'Não foi possível eliminar este email.']);            
        }        
    }

    public function send($email,$subject,$message, $project, $category, $desc){
        Mail::to($email,name: 'Inscrito')->send(new SendNewsletter([
            'email' => $email,
            'subject' => $subject,
            'message' => $message,
            'project' => $project,
            'category' => $category,
            'desc' => $desc
        ]));
    }

    public function sendNewsletterToSubscribers($message, $project, $category, $desc)
    {
        $subscribers = Newsletter::where('status', 1)->pluck('email');
        if ($subscribers->count() > 0) {
            foreach ($subscribers as $email) {
                $this->send($email, "Novidade de projectos!", $message, $project, $category, $desc);
            }
        } 
    }

}
