<?php

namespace App\Http\Controllers;

use App\Models\Social;
use App\Models\System;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class SystemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $systems = System::all();
        $firstSystem = $systems->first();
        $images = DB::table('images')->get();
        return view(
            'admin.system.configutations', 
            [
                'data' => $firstSystem,
                'social' => Social::all(),
                'images' => $images
                ]
        );
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, int $id)
    {
        try {
            // Sanitizar o ID
            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            // Dados a serem criados ou atualizados
            $data = [
                'about' => $request->input('about'),
                'titulo_1' => $request->input('titulo_1'),
                'titulo_2' => $request->input('titulo_2'),
                'titulo_3' => $request->input('titulo_3'),
                'desc_1' => $request->input('desc_1'),
                'desc_2' => $request->input('desc_2'),
                'desc_3' => $request->input('desc_3'),
                'address' => $request->input('address')
            ];

            // Verifica se o ID é válido
            if ($id == 0) {
                // Cria um novo registro se o ID for inválido
                $system = System::create($data);
                $id = $system->idsystem_data; // Atualiza o ID com o novo registro
            } else {
                // Tenta encontrar o registro existente
                $system = System::find($id);
                if (!$system) {
                    return redirect()->back()->with([
                        'status' => 'error',
                        'msg' => 'Não foi possível encontrar o registro para atualização.'
                    ]);
                }

                // Atualiza o registro
                $system->update($data);
            }

            return redirect()->back()->with([
                'status' => 'success',
                'msg' => 'Dados atualizados com sucesso!'
            ]);
        } catch (\Exception $e) {
            return redirect()->back()->with([
                'status' => 'error',
                'msg' => 'Ocorreu um erro ao guardar as alterações, tente novamente!'
            ]);
        }
    }

    public function updateEn(Request $request, int $id)
    {
        try {
            // Sanitizar o ID
            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            // Dados a serem criados ou atualizados
            $data = [
                'about_en' => $request->input('about_en'),
                'titulo_1_en' => $request->input('titulo_1'),
                'titulo_2_en' => $request->input('titulo_2'),
                'titulo_3_en' => $request->input('titulo_3'),
                'desc_1_en' => $request->input('desc_1_en'),
                'desc_2_en' => $request->input('desc_2_en'),
                'desc_3_en' => $request->input('desc_3_en')
            ];

            // Verifica se o ID é válido
            if ($id == 0) {
                // Cria um novo registro se o ID for inválido
                $system = System::create($data);
                $id = $system->idsystem_data; // Atualiza o ID com o novo registro
            } else {
                // Tenta encontrar o registro existente
                $system = System::find($id);
                if (!$system) {
                    return redirect()->back()->with([
                        'status' => 'error',
                        'msg' => 'Não foi possível encontrar o registro para atualização.'
                    ]);
                }

                // Atualiza o registro
                $system->update($data);
            }

            return redirect()->back()->with([
                'status' => 'success',
                'msg' => 'Dados atualizados com sucesso!'
            ]);
        } catch (\Exception $e) {
            return redirect()->back()->with([
                'status' => 'error',
                'msg' => 'Ocorreu um erro ao guardar as alterações, tente novamente!'
            ]);
        }
    }

    public function addImage(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:png,jpg,gif,mp4,mov,avi,wmv,flv,mkv|max:20480',
        ],[
            'file.required' => 'Seleciona uma capa',
            'file.mimes' => 'O arquivo deve ser [PNG, JPG, GIF, MP4, MOV, AVI, WMV, FLV, MKV].',
            'file.max' => 'O tamanho máximo do arquivo é 20MB.'
        ]);
    
        $filetype = trim($request->input('file_type'));

        if (!$request->file('file')->isValid()) {
            return redirect()->back()->withInput()->withErrors(['status' => 'error', 'msg' => 'O arquivo não é válido.']);
        }
    
        $file = $request->file('file');
        $filename = time() . '_' . $file->getClientOriginalName();
    
        $extension = strtolower($file->getClientOriginalExtension());
        $allowed_extensions = ['png', 'jpg', 'gif', 'mp4', 'mov', 'avi', 'wmv', 'flv', 'mkv'];

        if (!in_array($extension, $allowed_extensions)) {
            return redirect()->back()->withInput()->withErrors(['status' => 'error', 'msg' => 'O arquivo deve ser [PNG, JPG, GIF, MP4, MOV, AVI, WMV, FLV, MKV].']);
        }


        try {                        

            DB::table('images')->insert([
                'image' => $filename,
                'file_type' => $filetype,
                'extension_file' => $extension
            ]);
            
            // Armazenar o ficheiro no disco
            Storage::disk('public')->put('uploads/'. $filename, file_get_contents($file));
            
            self::InsertLogs("Adicionou uma imagem no sistema");
            return redirect()->back()->with(['status' => 'success', 'msg' => 'Ficheiro registado com sucesso!']);
        } catch (\Exception $e) {
            return redirect()->back()->with(['status' => 'error', 'msg' => "Não foi possível registar o ficheiro, tente novamente! "]);
        }
    }

    public function destroyImage(int $id)
    {
        try {
            $filteredId = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            // Seleciona as colunas necessárias da tabela
            $file = DB::table('images')
                ->where('idimage', $filteredId)
                ->select('image', 'idimage') // Certifica-te de que 'image' é o ficheiro
                ->first();

            if ($file) {
                // Verifica se o ficheiro existe no sistema de ficheiros
                if (Storage::disk('public')->exists('uploads/'.$file->image)) {
                    
                    // Elimina o ficheiro do sistema
                    Storage::disk('public')->delete('uploads/'.$file->image);

                    // Insere o log
                    self::InsertLogs("Eliminou uma imagem do sistema");

                    // Apaga o registo da base de dados com base em 'idimage'
                    DB::table('images')->where('idimage', $file->idimage)->delete();

                    return redirect()->back()->with(['status' => 'success', 'msg' => 'Ficheiro eliminado com sucesso!']);
                }
            }

            return redirect()->back()->with(['status' => 'error', 'msg' => "Não foi possível eliminar o ficheiro, tente novamente!"]);

        } catch (\Exception $e) {
            return redirect()->back()->with(['status' => 'error', 'msg' => "Não foi possível eliminar o ficheiro, tente novamente! ".$e->getMessage()]);
        }
    }

}