<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'vat' => ['required','integer'],
            'company' => ['required','string'],
            'name' => ['required','string'],
            'email' => ['required','email'],
            'phone' => ['required','string'],
            'password' => ['required','min:6','max:10']
        ];
    }

    public function messages(): array
    {
        return [
            'vat.required' => 'O NIF é obrigatório',
            'vat.integer' => 'O NIF deve ser do tipo numérico',
            
            'company.required' => 'Não foi encontrado nenhuma empresa',

            'email.required' => 'O email é obrigatório',
            'email.email' => 'Digite um email válido',

            'phone.required' => 'O telefone é obrigatório',
            
            'password.required' => 'A senha é obrigatória',
            'password.min' => 'A senha deve ter no mínimo :min caracteres',
            'password.max' => 'A senha deve ter no máximo :max caracteres',
        ];
    }
}
