<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;    

    protected $primaryKey = "idProject";

    protected $fillable = [
        'category',
        'category_en',
        'name_project',
        'client',
        'description_project',
        'description_project_en',
        'thumb',       
        'file_type',       
        'extension_file',       
        'status_project',
        'slug',
        'user_id'
    ];

    public function files() {
        return $this->hasMany(File::class);
    }

    public function users() {
        return $this->belongsTo(User::class);
    }
}
