<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            //$table->id();
            $table->bigIncrements('idProject')->primaryKey();
            $table->string('category', 100);
            $table->string('name_project', 100)->unique();;
            $table->string('client', 100);
            $table->string('thumb', 255);
            $table->string('file_type', 15);
            $table->string('extension_type', 15);
            $table->integer('status_project')->default('1');
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};