<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('files', function (Blueprint $table) {
            //$table->id();
            $table->bigIncrements('idFile')->primaryKey();
            $table->string('file', 50);
            $table->integer('status_file')->default('0');
            $table->unsignedBigInteger('project_id');
            $table->foreign('project_id')->references('idProject')->on('projects')->onDelete('cascade')->onUpdate('cascade'); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('files');
    }
};
