/**
 * ================================================================
 *                      IMG PREVIEW
 * ================================================================
 */
document.querySelector('.fileInput').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const mediaContainer = document.querySelector('.mediaContainer');
    const file_type = document.querySelector('.file_type');
    
    if (file) {
        const fileType = file.type.split('/')[0]; // Verifica o tipo de arquivo (imagem ou vídeo)
        const fileSizeMB = file.size / (1024 * 1024); // Tamanho do arquivo em MB

        if (fileType === 'image') {
            if ((file.type === 'image/png' || file.type === 'image/jpeg' || file.type === 'image/gif') && fileSizeMB <= 5) {
                const img = document.createElement('img');
                img.src = URL.createObjectURL(file);
                img.alt = 'Imagem';
                img.style = 'width: 100%; height: 400px;'
                mediaContainer.innerHTML = ''; // Limpa o conteúdo anterior
                mediaContainer.appendChild(img);
                file_type.value = "imagem";
            } else {
                showErrorAlert('Por favor, selecione uma imagem válida (PNG, JPG, GIF) com tamanho até 5MB.');
            }
        } else if (fileType === 'video') {
            if ((file.type === 'video/mp4' || file.type === 'video/mov' || file.type === 'video/avi' || 
                 file.type === 'video/wmv' || file.type === 'video/flv' || file.type === 'video/mkv') && 
                 fileSizeMB <= 20) {
                const video = document.createElement('video');
                video.src = URL.createObjectURL(file);
                video.controls = true;
                video.autoplay = true;
                video.loop = true;
                video.muted = true; // Reproduzir vídeo silenciosamente
                video.style = 'width: 100%; height: 300px;'
                mediaContainer.innerHTML = ''; // Limpa o conteúdo anterior
                mediaContainer.appendChild(video);
                file_type.value = "video";
            } else {
                showErrorAlert('Por favor, selecione um vídeo válido (MP4) com tamanho até 20MB.');
            }
        } else {
            showErrorAlert('Por favor, selecione uma imagem (PNG, JPG, GIF) ou vídeo (MP4).');
        }
    }
});

function showErrorAlert(message) {
    Swal.fire({
        position: 'center',
        title: 'Alerta!',
        icon: 'warning',
        text: message,
        showConfirmButton: true,
        confirmButtonText: 'OK',
        timer: 10000,   
        confirmButtonColor:'#ED1C24',
        backdrop: `rgba(237,28,36,0.4)`,
    });
}
