const nameCompany = document.querySelector("#company");
const nif = document.querySelector("#vat");
const button = document.querySelector("#checkNIF");
const span = document.querySelector("#sms_nif");
const loading = document.querySelector("#loading");

button.addEventListener("click", NIF);

function NIF() {
    // Mostra a imagem de loading antes de fazer a requisição
    loading.style.display = "flex";

    fetch(`https://consulta.edgarsingui.ao/public/consultar/${nif.value}/nif`)
        .then(response => {
            return response.json();
        })
        .then(body => {
            // Oculta a imagem de loading após receber a resposta
            loading.style.display = "none";

            if (body.error) {
                span.style = "color: red; font-weight: 600;";
                span.innerHTML = "NIF inválido";
                nameCompany.value = "";
            } else {
                span.style = "color: green; font-weight: 600;";
                span.innerHTML = "NIF válido";
                nameCompany.value = body.name;
            }
        })
        .catch(error => {
            loading.style.display = "none";
        });
}
