const listaItens = {
    maiuscula: document.getElementById('maiuscula'),
    minuscula: document.getElementById('minuscula'),
    especial: document.getElementById('especial'),
    numero: document.getElementById('numero'),
    comprimento: document.getElementById('comprimento')
  };

function verificarForcaSenha(senha) {
    const forca = {
      minimoCaracteres: senha.length >= 6,
      possuiMinuscula: /[a-z]/.test(senha),
      possuiMaiuscula: /[A-Z]/.test(senha),
      possuiNumero: /\d/.test(senha),
      possuiSimbolo: /[!@#$%^&*()_+\-=[\]{};':"\\|,.<>/?]/.test(senha)
    };
  
    let contador = 0;
    for (const prop in forca) {
      if (forca[prop]) {
        contador++;
      }
    }
  
    // Adapte essa lógica conforme necessário para informar sobre a força da senha
    if (contador === 5) {
      document.querySelector('.texto').innerText = "Senha forte!";
      document.querySelector('.texto').style = "color: green !important;";
    } else if (contador >= 3) {
        document.querySelector('.texto').innerText = "Senha média!";
        document.querySelector('.texto').style = "color: orange !important;";
    } else {
        document.querySelector('.texto').innerText = "Senha fraca!";
        document.querySelector('.texto').style = "color: red !important;";
    }    

  }
  
  // Exemplo de uso em um campo de senha (input type="password")
  const password = document.getElementById('password');
  
  password.addEventListener('input', function() {
    verificarForcaSenha(this.value);
    const senha = this.value;
    const criterios = {
        maiuscula: /[A-Z]/.test(senha),
        minuscula: /[a-z]/.test(senha),
        especial: /[!@#$%^&*()_+\-=[\]{};':"\\|,.<>/?]/.test(senha),
        numero: /\d/.test(senha),
        comprimento: senha.length >= 6
    };

    for (const criterio in criterios) {
        if (criterios[criterio]) {
        listaItens[criterio].style.color = 'green'; // Altera a cor para verde se o critério for atendido
        } else {
        listaItens[criterio].style.color = 'red'; // Altera a cor para vermelho se o critério não for atendido
        }
    }

    const senhaForte = Object.values(criterios).every(criterio => criterio);
    document.querySelector('.submit').disabled = !senhaForte;
  });
  

const toggleButton = document.getElementById('toggleSenha');
const toggleIcon = document.getElementById('toggleIcon');

toggleButton.addEventListener('click', function() {
  if (password.type === 'password') {
    password.type = 'text';
    toggleIcon.classList.remove('bi-eye-fill'); 
    toggleIcon.classList.add('bi-eye-slash-fill');
  } else {
    password.type = 'password';
    toggleIcon.classList.remove('bi-eye-slash-fill');
    toggleIcon.classList.add('bi-eye-fill');
  }
});
