/**
 * ================================================================
 *                      IMG PREVIEW
 * ================================================================
 */
document.getElementById('inputFile').addEventListener('change', function(event) {

    const input = event.target;
    const reader = new FileReader();

    reader.onload = function() {
        const previewImage = document.getElementById('previewImage');
        previewImage.src = reader.result;
    };

    if (input.files && input.files[0]) {
        const fileType = input.files[0].type;
        if (fileType.startsWith('image/png') || fileType.startsWith('image/jpeg') || fileType.startsWith('image/heic')) {
            reader.readAsDataURL(input.files[0]);
        } else {
            alert('Selecione uma imagem válida (PNG, JPG, HEIC).');
            input.value = '';
        }
    }
});

document.getElementById('removeImg').addEventListener('click', function(event) {
    alert('Clicou')
});