@extends('layout.dashboard')
@section('title', 'Histórico do Sistema - Kamba Animations')
@section('content')
    <div class="pagetitle">
        <h1>Subcrições</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">newsletter</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th scope="col">Tempo</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Data</th>
                                    <th scope="col"></th> 
                                </tr>
                            </thead>
                            <tbody>
                                @if($data->count()==0)
                                <tr>
                                    <td colspan="3">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-envelope"></i></h1>
                                            <h3> Não existem registos</h3>
                                        </div>
                                    </td>
                                </tr>
                                @else
                                    @foreach ($data as $item)
                                        <tr>
                                            <td>
                                                @if((\Carbon\Carbon::parse($item->created_at)->format('Y-m-d')) == date('Y-m-d'))
                                                <span class="badge text-bg-warning">Hoje</span>
                                                @elseif((\Carbon\Carbon::parse($item->created_at)->format('Y-m')) == date('Y-m'))
                                                <span class="badge text-bg-info">Este mês</span>
                                                @elseif((\Carbon\Carbon::parse($item->created_at)->format('Y')) == date('Y'))
                                                <span class="badge text-bg-primary">Este mês</span>
                                                @endif
                                            </td>
                                            <td>{{$item->email}}
                                            <td>@if($item->status==1) <span class="badge rounded-pill text-bg-success">Activo</span> @else <span class="badge rounded-pill text-bg-danger">Inactivo</span> @endif                                             
                                            <td>{{$item->created_at}}
                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="bi bi-three-dots"></i>
                                                        </button>
                                                        <ul class="dropdown-menu">
                                                            <li><a class="dropdown-item text-danger" href="#"type="button" data-bs-toggle="modal" data-bs-target="#delete{{$item->id}}"><i class="bi bi-trash"></i> Eliminar</a></li>
                                                        </ul>
                                                    </div>
                                                </td>
                                        </tr>
                                        <div class="modal fade" id="delete{{$item->id}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">                                            
                                                <div class="modal-body text-center">
                                                    <h5>Deseja eliminar esta subscrição?</h5>
                                                    <form action="{{ route('eliminar-newsletter',$item->id)}}" method="POST">
                                                        @method('DELETE');
                                                        @csrf
                                                        <button type="submit" class="btn btn-danger">Sim</button>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                    </form>
                                                </div>
                                            </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>   
@endsection
@section('script')
@include('script.datatable')
@endsection