@extends('layout.dashboard')
@section('title', 'Novo projecto - Kamba Animation')
@section('content')
    <div class="pagetitle">
        <h1>Novo projecto</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{url('projectos')}}">Projectos</a></li>
                <li class="breadcrumb-item active">Adicionar itens</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-5">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <form enctype="multipart/form-data" action="{{route('registar-adicional')}}" method="post" class="form">
                            @csrf
                            <div class="row">                                
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="row">                                        
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Ficheiro</label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Seleciona um ficheiro</label>
                                            <input type="text" hidden name="id" value="{{$id}}">
                                            <input type="file" hidden name="file" id="file" class="fileInput">
                                            <input type="text" hidden name="file_type" required class="file_type">
                                        </div>
                                        <div class="col-lg-12 mt-3">
                                            <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                        </div>
                                    </div>
                                </div> 
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer"></div>                               
                            </div>
                        </form>
                        <hr>
                        <strong>Total de adicionais</strong> " {{ $total }} "
                        <div class="row mt-5">
                            @if(empty($data))
                                <div class="col-12 p-5 text-center">
                                    <h3 class="text-muted">Sem itens adicionais</h3>
                                </div>
                            @else
                                @foreach($data as $item)
                                    <div class="col-lg-4 col-md-4 col-sm-12 mb-5">
                                        <div class="media-container">
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#capa{{$item->idFile}}" title="Clicar para abrir">
                                                @if($item->file_type2 == "imagem")
                                                    <img src="{{ asset('storage/uploads/project_'.$id.'/'.$item->file) }}" class="img-fluid rounded-2">
                                                @else
                                                    <video controls muted class="img-fluid rounded-2">
                                                        <source src="{{ asset('storage/uploads/project_'.$id.'/'.$item->file) }}" type="video/{{ $item->extension_file2 }}">
                                                        Seu navegador não suporta vídeos HTML5.
                                                    </video>
                                                @endif  
                                            </a>                                            
                                        </div>  
                                        <div class="media-container-bottom pt-2">
                                            <a href="#" class="text-danger" type="button" data-bs-toggle="modal" data-bs-target="#delete{{$item->idFile}}"><i class="bi bi-trash"></i> Eliminar</a>
                                        </div>                                   
                                    </div>

                                    <div class="modal fade" id="delete{{$item->idFile}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                          <div class="modal-content">                                              
                                            <div class="modal-body text-center">
                                                <h5>Deseja eliminar este ficheiro?</h5>
                                                <form action="{{ route('eliminar-adicional',$item->idFile)}}" method="POST">
                                                    @method('DELETE');
                                                    @csrf
                                                    <button type="submit" class="btn btn-danger">Sim</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                </form>
                                            </div>
                                          </div>
                                        </div>
                                    </div>
                                    <div class="modal fade" id="capa{{$item->idFile}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog  modal-xl">
                                          <div class="modal-content">                                            
                                                @if($item->file_type2 == 'imagem')
                                                <img src="{{asset('storage/uploads/project_'.$id.'/'.$item->file)}}" class="img-fluid">
                                                @else
                                                <video autoplay controls muted>
                                                    <source src="{{asset('storage/uploads/project_'.$id.'/'.$item->file)}}" type="video/{{$item->extension_file2}}">
                                                    Seu navegador não suporta vídeos HTML5.
                                                  </video>
                                                @endif
                                          </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
@endsection
@section('script')
<script src="{{ asset('assets/js/default-admin.js') }}"></script>
@endsection