@extends('layout.dashboard')
@section('title', 'Projectos - Kamba Animation')
@section('content')
    <div class="pagetitle">
        <h1>Projectos</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Projectos</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="col col-12 d-flex justify-content-end mb-3 border-bottom p-2">
            <a class="btn btn-success btn-sm" href="{{ url('projectos/novo-projecto') }}">
                <i class="bi bi-plus-lg"></i> Novo Projecto
            </a>

        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>#
                                    <th scope="col">Capa</th>
                                    <th scope="col">Categoria</th>
                                    <th scope="col">Nome</th>      
                                    <th scope="col"></th>                                    
                                </tr>
                            </thead>
                            <tbody>
                                @if ($data->count()==0)
                                <tr>
                                    <td colspan="5">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-tags"></i></h1>
                                            <h3> Não existem registos</h3>
                                        </div>
                                    </td>
                                </tr>
                                @else
                                    @foreach ($data as $item)
                                    <tr>
                                        <td> {{App\Http\Controllers\Controller::Time($item->created_at)}} <br> <small>({{$item->created_at}})</small>
                                        <td><button class="btn btn-light btn-sm" type="button" data-bs-toggle="modal" data-bs-target="#capa{{$item->idProject}}"><i class="bi bi-file-image-fill"></i></button></td>
                                        <td>{{$item->category}}</td>
                                        <td>{{$item->name_project}}</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="bi bi-three-dots"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li><a href="{{url('projectos/adicionais/'.$item->idProject)}}" class="dropdown-item"><i class="bi bi-images"></i> Imagens</a></li>
                                                    <li><a class="dropdown-item" href="#" type="button" data-bs-toggle="modal" data-bs-target="#modal{{$item->idProject}}"><i class="bi bi-eye"></i> Ver mais</a></li>
                                                    <li><a href="{{url('projectos/editar/'.$item->idProject)}}" class="dropdown-item"><i class="bi bi-pencil-square"></i> Editar</a></li>
                                                    <li><a class="dropdown-item" href="#"type="button" data-bs-toggle="modal" data-bs-target="#delete{{$item->idProject}}"><i class="bi bi-trash"></i> Eliminar</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    <div class="modal fade" id="delete{{$item->idProject}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                          <div class="modal-content">                                            
                                            <div class="modal-body text-center">
                                                <h5>Deseja eliminar este ficheiro?</h5>
                                                <form action="{{ route('eliminar-projecto',$item->idProject)}}" method="POST">
                                                    @method('DELETE');
                                                    @csrf
                                                    <button type="submit" class="btn btn-danger">Sim</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                </form>
                                            </div>
                                          </div>
                                        </div>
                                    </div>
                                    
                                    <div class="modal fade" id="modal{{$item->idProject}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                          <div class="modal-content">
                                            <div class="modal-header">
                                              <h1 class="modal-title fs-5" id="exampleModalLabel">{{$item->name_project}}</h1>
                                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Categoria</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">
                                                                {{$item->category}}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Nome do projecto</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">
                                                                {{$item->name_project}}
                                                            </div>
                                                        </div>
                                                    </div>                                                    
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Cliente</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12 d-flex align-items-center">
                                                                {{$item->client}}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Registado aos</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">
                                                                {{$item->created_at}}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3 p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Estado</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">                                                                
                                                                @if($item->status_project==1)
                                                                    <h6><span class="badge rounded-pill text-bg-success">Activo</span></h6>                                                
                                                                @else
                                                                    <h6><span class="badge rounded-pill text-bg-warning">Inactivo</span></h6>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                              <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Sair</button>
                                            </div>
                                          </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="capa{{$item->idProject}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog  modal-xl">
                                          <div class="modal-content">                                            
                                                @if($item->file_type == 'imagem')
                                                <img src="{{asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb)}}" class="img-fluid" alt="{{$item->name_project}}">
                                                @else
                                                <video id="background-video" autoplay controls muted>
                                                    <source src="{{asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb)}}" type="video/{{$item->extension_file}}">
                                                    Seu navegador não suporta vídeos HTML5.
                                                  </video>
                                                @endif
                                          </div>
                                        </div>
                                    </div>
                                    
                                    @endforeach
                                @endif                                
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
@include('script.datatable')
@endsection