@extends('layouts.layout_main')
@section('title', 'Notificações - SILCIR')
@section('content')
    <div class="pagetitle">
        <h1>Notificações</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Notificações</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th scope="col">Nome</th>
                                    <th scope="col">Descrição</th>
                                    <th scope="col">Data</th>
                                    <th scope="col"><i class="bi bi-three-dots"></i></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="7" rows="7">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-bell"></i></h1>
                                            <h3> Não existem notificações</h3>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Novo Utilizador</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <!-- General Form Elements -->
                <form method="POST" action="/adm/mainc">
                    <div class="modal-body p-5">
                        <div class="col-lg-12">
                            <label for="inputText" class="col-12 col-form-label">Nome</label>
                            <input type="text" name="name" required class="form-control">
                        </div>
                        <div class="row mb-3">
                            <label for="inputEmail" class="col-12 col-form-label">Email</label>
                            <div class="col-12">
                                <input type="email" name="email" required class="form-control">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-lg-6 col-sm-12">
                                <label for="inputPassword" class="col-12 col-form-label">Palavra passe</label>
                                <div class="col-12">
                                    <input type="password" minlength="6" name="password" required class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <label class="col-12 col-form-label">Nível de acesso</label>
                                <select class="form-select" name="level">
                                    <option value="Administrador">Administrador</option>
                                    <option value="Supervisor">Supervisor</option>
                                    <option value="Normal">Normal</option>
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer justify-content-end p-5 pt-3 pb-3">
                        <button type="submit" class="btn btn-success w-50" name="newUser">Guardar</button>
                    </div>
                </form><!-- End General Form Elements -->
            </div>
        </div>
    </div>
@endsection
