@extends('layout.dashboard')
@section('title', 'Configuração do Sistema - Kamba Animation')
@section('content')
    <div class="pagetitle">
        <h1>Sistema</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item active">Sistema</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">

                <div class="card">
                    <div class="card-body pt-3">
                        <ul class="nav nav-tabs nav-tabs-bordered" id="borderedTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                    data-bs-target="#bordered-home" type="button" role="tab" aria-controls="home"
                                    aria-selected="true">Versão Portugues</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="contact-tab" data-bs-toggle="tab"
                                    data-bs-target="#bordered-contact" type="button" role="tab" aria-controls="contact"
                                    aria-selected="false">Versão Inglês</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="image-tab" data-bs-toggle="tab"
                                    data-bs-target="#bordered-image" type="button" role="tab" aria-controls="image"
                                    aria-selected="false">Imagens</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="social-tab" data-bs-toggle="tab"
                                    data-bs-target="#bordered-social" type="button" role="tab" aria-controls="social"
                                    aria-selected="false">Contactos</button>
                            </li>
                        </ul>
                        <div class="tab-content mt-3 p-5" id="borderedTabContent">
                            <div class="tab-pane fade show active" id="bordered-home" role="tabpanel"
                                aria-labelledby="home-tab">
                                <form method="POST" action="{{ route('sistema.update', $data->idsystem_data) }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="modal-body">
                                        <div class="row mb-3">
                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="address" class="col-12 col-form-label">Endereço</label>
                                                <input type="text" name="address" id="address" class="form-control"
                                                    @if ($data != null && $data->count() > 0) value="{{ $data->address }}" @endif>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="inputText" class="col-12 col-form-label">Sobre nós</label>
                                                <textarea class="tinymce-editor" name="about" id="about" cols="30" rows="5" required> @if ($data != null && $data->count() > 0){{ $data->about }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="titulo_1" class="col-12 col-form-label">Titulo 1</label>
                                                <input type="text" name="titulo_1" id="titulo_1" class="form-control" value="@if ($data != null && $data->count() > 0){{ $data->titulo_1 }} @endif">
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="descricao_1" class="col-12 col-form-label">Informação</label>
                                                <textarea class="form-control" name="desc_1" id="descricao_1" cols="30" rows="5"> @if ($data != null && $data->count() > 0){{ $data->desc_1 }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="titulo_2" class="col-12 col-form-label">Titulo 2</label>
                                                <input type="text" name="titulo_2" id="titulo_2" class="form-control" value="@if ($data != null && $data->count() > 0){{ $data->titulo_2 }} @endif">
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="descricao_2" class="col-12 col-form-label">Informação</label>
                                                <textarea class="form-control" name="desc_2" id="descricao_2" cols="30" rows="5"> @if ($data != null && $data->count() > 0){{ $data->desc_2 }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="titulo_3" class="col-12 col-form-label">Titulo 3</label>
                                                <input type="text" name="titulo_3" id="titulo_3" class="form-control" value="@if ($data != null && $data->count() > 0){{ $data->titulo_3 }} @endif">
                                            </div>
                                            
                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="descricao_1" class="col-12 col-form-label">Informação</label>
                                                <textarea class="form-control" name="desc_3" id="descricao_1" cols="30" rows="5"> @if ($data != null && $data->count() > 0){{ $data->desc_3 }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mt-5 d-flex justify-content-end">
                                                <input type="hidden" name="id" @if ($data != null && $data->count() > 0) value="{{ $data->idsystem_data }}" @endif>
                                                <button type="submit" class="btn btn-success" name="save">Guardar</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="bordered-contact" role="tabpanel"
                                aria-labelledby="contact-tab">
                                <form method="POST" action="{{ route('sistema.updateen', $data->idsystem_data) }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="modal-body">
                                        <div class="row mb-3">

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="inputText" class="col-12 col-form-label">Sobre nós</label>
                                                <textarea class="tinymce-editor" name="about_en" id="about" cols="30" rows="5" required> @if ($data != null && $data->count() > 0){{ $data->about_en }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="titulo_1" class="col-12 col-form-label">Titulo 1</label>
                                                <input type="text" name="titulo_1" id="titulo_1" class="form-control" value="@if ($data != null && $data->count() > 0){{ $data->titulo_1_en }} @endif">
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="descricao_1" class="col-12 col-form-label">Informação</label>
                                                <textarea class="form-control" name="desc_1_en" id="descricao_1" cols="30" rows="5"> @if ($data != null && $data->count() > 0){{ $data->desc_1_en }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="titulo_2" class="col-12 col-form-label">Titulo 2</label>
                                                <input type="text" name="titulo_2" id="titulo_2" class="form-control" value="@if ($data != null && $data->count() > 0){{ $data->titulo_2_en }} @endif">
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="descricao_2" class="col-12 col-form-label">Informação</label>
                                                <textarea class="form-control" name="desc_2_en" id="descricao_2" cols="30" rows="5"> @if ($data != null && $data->count() > 0){{ $data->desc_2_en }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="titulo_3" class="col-12 col-form-label">Titulo 3</label>
                                                <input type="text" name="titulo_3" id="titulo_3" class="form-control" value="@if ($data != null && $data->count() > 0){{ $data->titulo_3_en }} @endif">
                                            </div>
                                            
                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="descricao_3" class="col-12 col-form-label">Informação</label>
                                                <textarea class="form-control" name="desc_3_en" id="descricao_3" cols="30" rows="5"> @if ($data != null && $data->count() > 0){{ $data->desc_3_en }} @endif </textarea>
                                            </div>

                                            <div class="col-lg-12 col-sm-12 mt-5 d-flex justify-content-end">
                                                <input type="hidden" name="id" @if ($data != null && $data->count() > 0) value="{{ $data->idsystem_data }}" @endif>
                                                <button type="submit" class="btn btn-success" name="save">Guardar</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="bordered-image" role="tabpanel"
                                aria-labelledby="social-tab">
                                <div class="modal-body">
                                    <div class="d-flex justify-content-end">
                                        <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal"
                                            data-bs-target="#staticBackImage">
                                            <i class="bi bi-plus"></i> Nova foto
                                        </button>
                                    </div>
                                    <table class="table datatable">
                                        <thead>
                                            <tr>
                                                <th scope="col">Imagem</th>
                                                <th scope="col"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if ($images->count() == 0)
                                                <tr>
                                                    <td colspan="2">
                                                        <div class="text-center p-5">
                                                            <h1 style="font-size: 4rem !important;"><i
                                                                    class="bi bi-image"></i></h1>
                                                            <h3> Não existem registos</h3>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @else
                                                @foreach ($images as $item)
                                                    <tr>
                                                        <td>
                                                            <button class="btn btn-light btn-sm" type="button" data-bs-toggle="modal" data-bs-target="#capa{{$item->idimage}}">
                                                                @if($item->file_type == 'imagem')
                                                                <img src="{{asset('storage/uploads/'.$item->image)}}" width="100">
                                                                @else
                                                                <video id="background-video" autoplay  muted width="100">
                                                                    <source src="{{asset('storage/uploads/'.$item->image)}}" type="video/{{$item->extension_file}}">
                                                                    Seu navegador não suporta vídeos HTML5.
                                                                  </video>
                                                                @endif
                                                            </button>
                                                        </td>
                                                        <td>
                                                            <div class="dropdown">
                                                                <button class="btn btn-light dropdown-toggle"
                                                                    type="button" data-bs-toggle="dropdown"
                                                                    aria-expanded="false">
                                                                    <i class="bi bi-three-dots"></i>
                                                                </button>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item"
                                                                            href="#"type="button"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-target="#deleteImage{{ $item->idimage }}"><i
                                                                                class="bi bi-trash"></i> Eliminar</a></li>
                                                                </ul>
                                                            </div>
                                                        </td>
                                                    </tr>

                                                    <div class="modal fade" id="deleteImage{{ $item->idimage }}"
                                                        tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-body text-center">
                                                                    <h5>Deseja eliminar?</h5>
                                                                    <form
                                                                        action="{{ route('sistema.delete.image', $item->idimage) }}"
                                                                        method="POST">
                                                                        @method('DELETE');
                                                                        @csrf
                                                                        <button type="submit"
                                                                            class="btn btn-danger">Sim</button>
                                                                        <button type="button" class="btn btn-secondary"
                                                                            data-bs-dismiss="modal">Não</button>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="modal fade" id="capa{{ $item->idimage }}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                                        <div class="modal-dialog  modal-xl">
                                                          <div class="modal-content">                                            
                                                                @if($item->file_type == 'imagem')
                                                                <img src="{{asset('storage/uploads/'.$item->image)}}" class="img-fluid">
                                                                @else
                                                                <video id="background-video" autoplay controls muted>
                                                                    <source src="{{asset('storage/uploads/'.$item->image)}}" type="video/{{$item->extension_file}}">
                                                                    Seu navegador não suporta vídeos HTML5.
                                                                  </video>
                                                                @endif
                                                          </div>
                                                        </div>
                                                    </div>

                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="bordered-social" role="tabpanel"
                                aria-labelledby="social-tab">

                                <div class="modal-body">
                                    <div class="d-flex justify-content-end">
                                        <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal"
                                            data-bs-target="#staticBackdrop">
                                            <i class="bi bi-plus"></i> Novo contacto
                                        </button>
                                    </div>
                                    <table class="table datatable">
                                        <thead>
                                            <tr>
                                                <th scope="col">Rede</th>
                                                <th scope="col">Nome do Perfil</th>
                                                <th scope="col">Link / Telefone / E-mail</th>
                                                <th scope="col"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if ($social->count() == 0)
                                                <tr>
                                                    <td colspan="5">
                                                        <div class="text-center p-5">
                                                            <h1 style="font-size: 4rem !important;"><i
                                                                    class="bi bi-tags"></i></h1>
                                                            <h3> Não existem registos</h3>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @else
                                                @foreach ($social as $item)
                                                    <tr>
                                                        <td><h5><i class="bi {{ $item->social }}"></i></h5></td>
                                                        <td>{{ $item->name }}</td>
                                                        <td>
                                                            <a href="@if($item->social == 'bi-envelope') mailto:{{$item->link}}
                                                                @elseif($item->social == 'bi-phone') tel:{{$item->link}}
                                                                @elseif($item->social == 'bi-whatsapp') https://wa.me/{{$item->link}}
                                                                @else
                                                                {{ $item->link }}
                                                                @endif" target="_blank" class="text-decoration-underline">
                                                                {{ $item->link }} <i
                                                                class="bi bi-box-arrow-up-right"></i></a></td>
                                                        <td>
                                                            <div class="dropdown">
                                                                <button class="btn btn-light dropdown-toggle"
                                                                    type="button" data-bs-toggle="dropdown"
                                                                    aria-expanded="false">
                                                                    <i class="bi bi-three-dots"></i>
                                                                </button>
                                                                <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item"
                                                                            href="#"type="button"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-target="#delete{{ $item->idsocial_midia }}"><i
                                                                                class="bi bi-trash"></i> Eliminar</a></li>
                                                                </ul>
                                                            </div>
                                                        </td>
                                                    </tr>

                                                    <div class="modal fade" id="delete{{ $item->idsocial_midia }}"
                                                        tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-body text-center">
                                                                    <h5>Deseja eliminar?</h5>
                                                                    <form
                                                                        action="{{ route('social.delete', $item->idsocial_midia) }}"
                                                                        method="POST">
                                                                        @method('DELETE');
                                                                        @csrf
                                                                        <button type="submit"
                                                                            class="btn btn-danger">Sim {{ $item->idsocial_midia }}</button>
                                                                        <button type="button" class="btn btn-secondary"
                                                                            data-bs-dismiss="modal">Não</button>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal -->
    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Modal title</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form enctype="multipart/form-data" action="{{ route('rede-social') }}" method="post"
                        class="form">
                        @csrf
                        <div class="row">
                            <div class="col-lg-12 col-sm-12 mb-3">
                                <label id="social">Rede Social</label>
                                <select name="social" id="social">
                                    <option value="bi-behance">Behance</option>
                                    <option value="bi-envelope">E-mail</option>
                                    <option value="bi-facebook">Facebook</option>
                                    <option value="bi-instagram">Instagram</option>
                                    <option value="bi-pinterst">Pinterst</option>
                                    <option value="bi-phone">Telefone</option>
                                    <option value="bi-vimeo">Vimeo</option>
                                    <option value="bi-whatsapp">WhatsApp</option>
                                    <option value="bi-globe2">Outra</option>
                                </select>
                            </div>
                            <div class="col-lg-12 col-sm-12 mb-3">
                                <label id="name">Nome do perfil</label>
                                <input type="text" name="name" id="name" required>
                            </div>
                            <div class="col-lg-12 col-sm-12 mb-3">
                                <label id="link">Link / Email / Telefone</label>
                                <input type="text" name="link" id="link">
                            </div>
                            <div class="col-lg-6 col-sm-12 text-center mediaContent"></div>
                            <div class="col-lg-12 mt-3 d-flex justify-content-end">
                                <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="staticBackImage" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Modal title</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form enctype="multipart/form-data" action="{{route('sistema.image')}}" method="post" class="form">
                        @csrf
                        <div class="row">                                
                            <div class="col-lg-6 col-md-6 col-sm-12">
                                <div class="row">                                        
                                    <div class="col-12 mb-3">
                                        <label>Ficheiro</label>
                                        <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Seleciona um ficheiro</label>                                        
                                        <input type="file" hidden name="file" id="file" class="fileInput">
                                        <input type="text" hidden name="file_type" required class="file_type">
                                    </div>
                                    <div class="col-lg-12 mt-2">
                                        <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                    </div>
                                </div>
                            </div> 
                            <div class="col-12 text-center mediaContainer mt-3"></div>                               
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
<script src="{{ asset('assets/js/default-admin.js') }}"></script>
@endsection