@extends('layout.dashboard')
@section('title', 'Histórico do Sistema - Kamba Animations')
@section('content')
    <div class="pagetitle">
        <h1>Histórico do Sistema</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Logs</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
           {{-- <div class="col-12 d-flex justify-content-end mb-3">
                <a href="#" class="btn btn-dark btn-sm"><i class="bi bi-printer-fill"></i> Exportar PDF</a>
            </div> --}}
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th scope="col">Tempo</th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">Descrição</th>
                                    <th scope="col">Data</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($data->count()==0)
                                <tr>
                                    <td colspan="7" rows="7">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-clock-history"></i></h1>
                                            <h3> Não existem registos</h3>
                                        </div>
                                    </td>
                                </tr>
                                @else
                                    @foreach ($data as $item)
                                        <tr>
                                            <td>
                                                @if((\Carbon\Carbon::parse($item->created_at)->format('Y-m-d')) == date('Y-m-d'))
                                                <span class="badge text-bg-warning">Hoje</span>
                                                @elseif((\Carbon\Carbon::parse($item->created_at)->format('Y-m')) == date('Y-m'))
                                                <span class="badge text-bg-info">Este mês</span>
                                                @elseif((\Carbon\Carbon::parse($item->created_at)->format('Y')) == date('Y'))
                                                <span class="badge text-bg-primary">Este mês</span>
                                                @endif
                                            </td>
                                            <td>{{$item->user}}
                                            <td>{{$item->operation}}
                                            <td>{{$item->created_at}}
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>   
@endsection
@section('script')
    @include('script.datatable')
@endsection