@extends('layout.dashboard')
@section('title', 'Perfil - Kamba Animation')
@section('content')
    <div class="pagetitle">
        <h1>Perfil</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Perfil</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-xl-4">

                <div class="card">
                  <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">    
                    @if($user->thumb=="default")
                        <img src="{{asset('assets/img/avatar.png')}}" class="rounded-circle img-thumbnail" style="width: 160px; height: 160px;" alt="">
                    @else
                        <img src="{{asset('storage/avatar/'.$user->thumb)}}" class="rounded-circle" style="width: 160px; height: 160px" alt="">
                    @endif
                    <h4 class="mt-3">{{$user->name}}</h2>
                    <h5 class="text-muted">{{$level}}</h5>
                    <span class="text-muted">{{$user->email}}</span>
                  </div>
                </div>
      
              </div>
      
              <div class="col-xl-8">
                    <div class="card">
                        <div class="card-body p-5">
                            <!-- Bordered Tabs -->
                            <ul class="nav nav-tabs nav-tabs-bordered" id="borderedTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#bordered-home"
                                        type="button" role="tab" aria-controls="home" aria-selected="true">Informações Pessoais</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#bordered-contact"
                                        type="button" role="tab" aria-controls="contact" aria-selected="false">Palavra
                                        passe</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="auth-tab" data-bs-toggle="tab" data-bs-target="#bordered-auth"
                                        type="button" role="tab" aria-controls="auth" aria-selected="false">Autenticação</button>
                                </li>
                            </ul>
                            <div class="tab-content mt-3 p-5" id="borderedTabContent">
                                <div class="tab-pane fade show active" id="bordered-home" role="tabpanel" aria-labelledby="home-tab">
                                    <form action="{{route('perfil.edit')}}" method="post" class="form" enctype="multipart/form-data">     
                                        @csrf                                   
                                        @method('PUT')
                                        <div class="row">     
                                            <div class="col-12 text-center mb-3">
                                                @if($user->thumb=="default")
                                                    <img src="{{asset('assets/img/avatar.png')}}" id="previewImage" style="width: 102px; height: 102px;" alt="">
                                                @else
                                                    <img src="{{asset('storage/avatar/'.$user->thumb)}}" id="previewImage" style="width: 150px; height: 150px;" alt="">
                                                @endif
                                                <div class="mt-3 d-flex justify-content-center">
                                                    <input type="file" name="thumb" id="inputFile" hidden>
                                                    <label for="inputFile" class="btn btn-primary btn-sm"><i class="bi bi-upload"></i></label>&ensp;
                                                    <label class="btn btn-danger btn-sm" id="removeImg"><i class="bi bi-trash"></i></label>
                                                </div>
                                            </div>                  
                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="name" class="form-label">Nome</label>
                                                <input type="text" value="{{ $user->name }}"name="name" id="name"
                                                    placeholder="O seu nome">
                                            </div>
                                            <div class="col-lg-12 col-sm-12 mb-3">
                                                <label for="email" class="form-label">E-mail</label>
                                                <input type="email" disabled value="{{ $user->email }}" name="email"
                                                    id="email" placeholder="O seu email">
                                            </div>
                                            <div class="col-lg-12 mt-3 d-flex justify-content-end">
                                                <button class="btn btn-success btn-sm">Guardar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="tab-pane fade" id="bordered-contact" role="tabpanel" aria-labelledby="contact-tab">
                                    <form action="{{route('perfil.password')}}" method="post" class="form">
                                        @csrf 
                                        @method('PUT')                                                     
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="row">
                                                    <div class="col-lg-6 col-sm-12 mb-3">
                                                        <label for="old" class="form-label">Palavra passe antiga</label>
                                                        <input type="password" id="old" name="old" placeholder="******">
                                                    </div>
                                                    <div class="col-lg-6 col-sm-12 mb-3">
                                                        <div class="row">
                                                            <div class="col-12 ps-word mb-3">
                                                                <label for="password" class="form-label">Palavra passe</label>
                                                                <input type="password" name="password" min="6" required style="padding-right: 40px !important;" id="password" placeholder="No mínimo 6 caracteres">
                                                                <button id="toggleSenha" class="btn" type="button">
                                                                    <i id="toggleIcon" class="bi bi-eye-fill"></i>
                                                                </button>
                                                            </div>
                                                            <div class="col-12">
                                                                    A palavra passe deve conter pelomenos:
                                                                    <ul id="verificarSenha" class="p-0" style="list-style: none !important;">
                                                                        <li id="maiuscula"><i class="bi bi-check-circle"></i> Uma letra maiúscula</li>
                                                                        <li id="minuscula"><i class="bi bi-check-circle"></i> Uma letra minúscula</li>
                                                                        <li id="especial"><i class="bi bi-check-circle"></i> Um caracter especial</li>
                                                                        <li id="numero"><i class="bi bi-check-circle"></i> Um número</li>
                                                                        <li id="comprimento"><i class="bi bi-check-circle"></i> Pelo menos 6 caracteres</li>
                                                                      </ul>
                                                                <span class="texto"></span>
                                                            </div>
                                                        </div> 
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mt-3 d-flex justify-content-end">
                                                <button class="btn btn-success submit" disabled>Guardar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="tab-pane fade" id="bordered-auth" role="tabpanel" aria-labelledby="auth-tab">
                                    <form action="{{route('perfil.auth')}}" method="post" class="form">
                                        @csrf 
                                        @method('PUT')
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <label for="auth_2fa">Autenticação em 2 factores</label>
                                                <input type="checkbox" name="auth_2fa" @if($user->auth_2fa) checked @endif id="auth_2fa" style="width: auto !important;">
                                            </div>
                                            <div class="col-lg-12 mt-3">
                                                <button class="btn btn-success btn-sm">Guardar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
              </div>
        </div>        
    </section>

@endsection
@section('script')
<script src="{{ asset('assets/js/password.js') }}"></script>
<script src="{{ asset('assets/js/preview.js') }}"></script>
@endsection