@extends('layout.dashboard')
@section('title', 'Novo projecto - Kamba Animation')
@section('content')
    <div class="pagetitle">
        <h1>Novo membro</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{route('team')}}">Team</a></li>
                <li class="breadcrumb-item active">Novo membro</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-5">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        @if(!isset($team))
                        <form enctype="multipart/form-data" action="{{route('registar.membro')}}" method="post" class="form">
                            @csrf
                            <div class="row">                                
                                <div class="col-6">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Fotografia <span class="text-danger">*</span></label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Selecionar uma</label>
                                            <input type="file" hidden name="file" required id="file" class="fileInput">
                                        </div>
                                        <div class="col-12 mb-3">
                                            <label id="name">Nome<span class="text-danger">*</span></label>
                                            <input type="text" name="name" required id="name" placeholder="Nome">
                                        </div>      
                                        <div class="col-12 mb-3">
                                            <label id="especiality">Especialiadade</label>
                                            <input type="text" name="especiality" id="especiality" placeholder="Especialidade">
                                        </div>                                            
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer"></div>
                                <div class="col-lg-12 mt-3">
                                    <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                </div>
                            </div>
                        </form>
                        @else
                        <form enctype="multipart/form-data" action="{{route('update.membro', $team->idteam)}}" method="post" class="form">
                            @method('PUT')
                            @csrf
                            <div class="row">                                
                                <div class="col-6">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Fotografia</label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Selecionar uma</label>
                                            <input type="file" hidden name="file" id="file" class="fileInput">
                                        </div>
                                        <div class="col-12 mb-3">
                                            <label id="project">Nome</label>
                                            <input type="text" name="name" value="{{$team->name}}" required id="name" placeholder="Nome">
                                        </div>      
                                        <div class="col-12 mb-3">
                                            <label id="especiality">Especialidade</label>
                                            <input type="text" name="especiality" id="especiality" value="{{$team->especiality}}" placeholder="Especialidade">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer">
                                    @if($team->image == "default")
                                        <img src="{{asset('assets/img/avatar.png')}}"">
                                    @else                                                
                                        <img src="{{asset('storage/uploads/team/'.$team->image)}}">
                                    @endif
                                </div>
                                <div class="col-lg-12 mt-3">
                                    <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                </div>
                            </div>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    
@endsection
@section('script')
<script src="{{ asset('assets/js/preview.js') }}"></script>
@endsection