@extends('layout.dashboard')
@section('title', 'Team - Kamba Animation')
@section('content')
    <div class="pagetitle">
        <h1>Team</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Team</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="col col-12 d-flex justify-content-end mb-3">
            <a href="{{route('novo.membro')}}" class="btn btn-success btn-sm">
                <i class="bi bi-plus-lg"></i> Novo membro
            </a>

        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        @if ($errors->any())
                            <div class="alert alert-danger mb-5">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th scope="col"></th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">Especialidade</th>
                                    <th scope="col">Estado</th>
                                    <th scope="col"></th>
                                </tr>
                            </thead>
                            <tbody class="tbody-center">
                                @if($data->count()==0)
                                <tr>
                                    <td colspan="5">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-person"></i></h1>
                                            <h3> Não existem registos</h3>
                                        </div>
                                    </td>
                                </tr>
                                @else
                                    @foreach($data as $item)
                                    <tr>
                                        <td>
                                            @if($item->image == "default")
                                                <img src="{{asset('assets/img/avatar.png')}}" class="rounded-5 img-thumbnail" width="50" height="50" alt="">
                                            @else
                                                <img src="{{asset('storage/uploads/team/'.$item->image)}}" type="button" data-bs-toggle="modal" data-bs-target="#image{{$item->idteam}}" class="rounded-5 img-thumbnail" style="width: 50px !important; height: 50px !important;" alt="">
                                            @endif
                                        </td>
                                        <td>{{ $item->name }}
                                        <td>{{ $item->especiality }}
                                        <td>
                                            @if($item->status=='1')
                                                <h6><span class="badge rounded-pill text-bg-success">Activo</span></h6>                                                
                                            @else('Em tratamento')
                                                <h6><span class="badge rounded-pill text-bg-warning">Inactivo</span></h6>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="bi bi-three-dots"></i>
                                                </button>
                                                <ul class="dropdown-menu">                                                    
                                                    <li><a href="{{route('editar.membro',$item->idteam)}}" class="dropdown-item"><i class="bi bi-pencil-square"></i> Editar</a></li>
                                                    <li><a class="dropdown-item" href="#"type="button" data-bs-toggle="modal" data-bs-target="#delete{{$item->idteam}}"><i class="bi bi-trash"></i> Eliminar</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>

                                    <div class="modal fade" id="delete{{$item->idteam}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">                                            
                                            <div class="modal-body text-center">
                                                <h5>Deseja eliminar este membro</h5>
                                                <form action="{{ route('eliminar.membro',$item->idteam)}}" method="POST">
                                                    @method('DELETE');
                                                    @csrf
                                                    <button type="submit" class="btn btn-danger">Sim</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                </form>
                                            </div>
                                        </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="image{{$item->idteam}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog  modal-static">
                                          <div class="modal-content">                                            
                                                <img src="{{asset('storage/uploads/team/'.$item->image)}}" class="img-fluid" alt="{{$item->name}}">
                                          </div>
                                        </div>
                                    </div>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('script')
@include('script.datatable')
@endsection