@extends('layout.dashboard')
@section('title', 'Novo utilizador - SILCIR')
@section('content')
    <div class="pagetitle">
        <h1>Novo utilizador</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{url('utilizadores')}}">Utilizadores</a></li>
                <li class="breadcrumb-item active">Nova utilizador</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-5">
                        @if ($errors->any())
                            <div class="alert alert-danger mb-5">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <form action="{{ route('registar-utilizador') }}" method="post" class="form">
                            @csrf
                            <input type="text" value="@if(isset($data)){{$data->id}}@endif" hidden name="id">
                            <div class="row">
                                <div class="col-lg-6 col-sm-12 mb-3">
                                    <label id="name">Nome</label>
                                    <input type="text" value="@if(isset($data)){{$data->name}}@endif" placeholder="Informe o nome aqui" name="name" required id="name">
                                </div>                               
                                <div class="col-lg-3 col-md-3 col-sm-12 mb-3">
                                    <label id="Accesslevel">Nível de acesso</label>
                                    <select name="level" id="Accesslevel" required>
                                        <option value="11" selected>Administrador</option>                                        
                                        <option value="12">Normal</option>                                                     
                                    </select>
                                </div>
                                <div class="col-lg-6 col-sm-6 mb-3">
                                    <label id="email">Email</label>
                                    <input type="email" name="email" placeholder="Informe o email aqui" required id="email">
                                </div>
                                
                                <div class="col-lg-6 col-sm-12 mb-3">   

                                    <div class="row">
                                        <div class="col-12 ps-word mb-3">
                                            <label for="password" class="form-label">Palavra passe</label>
                                            <input type="password" name="password" min="6" required style="padding-right: 40px !important;" id="password" placeholder="No mínimo 6 caracteres">
                                            <button id="toggleSenha" class="btn" type="button">
                                                <i id="toggleIcon" class="bi bi-eye-fill"></i>
                                            </button>
                                        </div>
                                        <div class="col-12">
                                                A palavra passe deve conter pelomenos:
                                                <ul id="verificarSenha" class="p-0" style="list-style: none !important;">
                                                    <li id="maiuscula"><i class="bi bi-check-circle"></i> Uma letra maiúscula</li>
                                                    <li id="minuscula"><i class="bi bi-check-circle"></i> Uma letra minúscula</li>
                                                    <li id="especial"><i class="bi bi-check-circle"></i> Um caracter especial</li>
                                                    <li id="numero"><i class="bi bi-check-circle"></i> Um número</li>
                                                    <li id="comprimento"><i class="bi bi-check-circle"></i> Pelo menos 6 caracteres</li>
                                                  </ul>
                                            <span class="texto"></span>
                                        </div>
                                    </div> 
                                </div>
                                <div class="col-lg-12 mt-3 d-flex justify-content-end">
                                    <button class="btn btn-success submit" @if(!isset($data)) disabled @endif><i class="bi bi-send"></i> Guardar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('script')
<script src="{{ asset('assets/js/password.js') }}"></script>
@endsection