@extends('layout.main')
@section('title', 'Contact - Kamba Animation')
@section('content')
    <div class="banner-2">
        <div class="text-center p-5">
            <h1>@lang('messages.about_us_1')</h1>
            <p>@lang('messages.about_us_2')</p>
        </div>
    </div>
    <section id="about" class="about">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="row">
                        <div class="col-12 mb-5 service-content text-center">
                            <p>
                                @lang('messages.about_us')
                            </p>
                        </div>
                        <div class="col-12">
                            <div class="row text-center">
                                @if($about->titulo_1 != null)
                                    <div class="col-lg-4 col-sm-12 service-content">
                                        <h1>@lang('messages.titulo_1')</h1>
                                        <p>@lang('messages.desc_1')</p>
                                    </div>
                                @endif
                                @if($about->titulo_2 != null)
                                <div class="col-lg-4 col-sm-12 service-content">
                                    <h1>@lang('messages.titulo_2')</h1>
                                    <p>@lang('messages.desc_2')</p>
                                </div>
                                @endif
                                @if($about->titulo_3 != null)
                                <div class="col-lg-4 col-sm-12 service-content">
                                    <h1>@lang('messages.titulo_3')</h1>
                                    <p>@lang('messages.desc_3')</p>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="p-5 mt-3 mb-3 service-content">
                            <div id="carouselExampleInterval" class="carousel slide" data-bs-ride="carousel">
                                <div class="carousel-inner">
                                  @foreach($images as $index => $image)
                                    <div class="carousel-item {{ $index == 0 ? 'active' : '' }}" data-bs-interval="{{ $index == 0 ? '10000' : '2000' }}">
                                        @if($image->file_type == 'imagem')
                                        <img src="{{asset('storage/uploads/'.$image->image)}}" class="d-block w-100" style="border-radius: 20px !important;">
                                        @else
                                        <video id="background-video" autoplay  muted  class="d-block w-100" style="border-radius: 20px !important;" >
                                            <source src="{{asset('storage/uploads/'.$image->image)}}" type="video/{{$image->extension_file}}" >
                                            Seu navegador não suporta vídeos HTML5.
                                            </video>
                                        @endif                                      
                                    </div>
                                  @endforeach
                                </div>
                              
                                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleInterval" data-bs-slide="prev">
                                  <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                  <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleInterval" data-bs-slide="next">
                                  <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                  <span class="visually-hidden">Next</span>
                                </button>
                              </div>
                              
                        </div>
                        <section class="services p-5">
                            <div class="container text-center">
                                <div class="titles" id="services">
                                    <h1 class="sombra">@lang('messages.home_content_6')</h1>
                                    <h1 class="title">@lang('messages.home_content_6')</h1>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-5" style="padding: 0 8rem;">
                                    <div class="row">
                                        <div class="col-lg-3 col-md-12 col-sm-12 service-content">
                                            <i class="bi bi-film"></i>
                                            <strong>@lang('messages.home_alt_1')</strong>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 mb-5 service-content">
                                            <i class="bi bi-person"></i>
                                            <strong>@lang('messages.home_alt_2')</strong>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 mb-5 service-content">
                                            <i class="bi bi-volume-up"></i>
                                            <strong>@lang('messages.home_alt_3')</strong>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 mb-5 service-content">
                                            <i class="bi bi-camera-reels"></i>
                                            <strong>@lang('messages.home_alt_4')</strong>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 mb-5 service-content">
                                            <i class="bi bi-megaphone"></i>
                                            <strong>@lang('messages.home_alt_5')</strong>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 mb-5 service-content">
                                            <i class="bi bi-mouse2"></i>
                                            <strong>@lang('messages.home_alt_6')</strong>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 mb-5 service-content">
                                            <i class="bi bi-bag"></i>
                                            <strong>@lang('messages.home_alt_7')</strong>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 mb-5 service-content">
                                            <i class="bi bi-lightning"></i>
                                            <strong>@lang('messages.home_alt_8')</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                        @if ($team->count() > 0)
                            <div class="col-12 mt-5 mb-5 team">
                                <div class="col-12 mb-5 text-center titles">
                                    <h1 class="sombra">@lang('messages.about_us_3')</h1>
                                    <h1 class="title">@lang('messages.about_us_3')</h1>
                                </div>
                                <div class="row">
                                    @foreach ($team as $item)
                                        <div class="col-lg-3 col-sm-12 mb-4">
                                            <div
                                                class="card service-content card-team d-flex justify-content-center align-items-center">
                                                <img src="{{ asset('storage/uploads/team/' . $item->image) }}"
                                                    class="card-img-top" alt="...">
                                                <div class="card-body">
                                                    <strong class="card-title">{{ $item->name }}</strong><br>
                                                    <small>{{ $item->especiality }}</small>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
