@extends('layout.main')
@section('title','Contact - Kamba Animation')
@section('content')   
    <div class="banner-2">
        <div class="text-center p-5">
            <h3>@lang('messages.contact_content_1')</h3>            
        </div>          
    </div>
    <section id="contact" class="contact">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="row">
                        <div class="col-8 m-auto text-center mb-5 p-0">
                            <p>@lang('messages.contact_content_2')<br>@lang('messages.contact_content_3')</p>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 d-flex flex-column mb-5">
                            <span class="p-3"><i class="bi bi-pin-map"></i>&ensp;@lang('messages.contact_content_14')</span>
                            @if(empty($data))
                                <div class="h-100 d-flex justify-content-center align-items-center">@lang('messages.contact_content_4')</div>
                            @else
                                @foreach ($data as $item)
                                    <a href="@if($item->social == 'bi-envelope') mailto:{{$item->link}}
                                        @elseif($item->social == 'bi-phone') tel:{{$item->link}}
                                        @elseif($item->social == 'bi-whatsapp') https://wa.me/{{$item->link}}
                                        @else
                                        {{ $item->link }}
                                        @endif" target="_blank">
                                        <i class="bi {{$item->social}}"></i>&ensp;
                                        @if($item->social == 'bi-envelope') {{$item->link}}
                                        @elseif($item->social == 'bi-phone') {{$item->link}}
                                        @elseif($item->social == 'bi-whatsapp') {{$item->link}}
                                        @else
                                        {{ $item->name }}
                                        @endif
                                    </a>
                                @endforeach
                            @endif                            
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 mb-5">
                            <form action="{{route('send-mail')}}" method="post">
                                @csrf
                                <div class="mb-2">
                                    <input type="text" placeholder="@lang('messages.contact_content_5') *" required name="name">
                                </div>
                                <div class="mb-2">
                                    <input type="email" placeholder="@lang('messages.contact_content_6') *" required name="email">
                                </div>
                                <div class="mb-2">
                                    <textarea name="message" cols="30" rows="10" placeholder="@lang('messages.contact_content_7')" required></textarea>
                                </div>
                                <div class="mb-2">
                                    <button type="submit"><i class="bi bi-send"></i> @lang('messages.contact_content_8')</button>
                                </div>
                            </form>
                        </div>                        
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection