@extends('layout.main')
@section('title','Kamba Animation')
@section('content')    
    <section class="banner">    
        <div class="opacity d-flex justify-content-center align-items-start flex-column">
            <div class="container d-flex justify-content-center align-items-center">
                {{--<h1><strong class="text-white">KAMBA</strong> <span style="font-weight: 100; color: #FFC200;">ANIMATION</span></h1>
                <p>A melhor solução áudio visual <span class="quebra"></span> para o seu negócio</p>
                <img src=" {{asset('assets/img/bg.png')}}" alt="" class="img-floating position-absolute">--}}
                <div class="animar d-flex justify-content-center align-items-center">
                    <span style="margin-right: 1rem;">Animation - Motion Graphics</span>
                    <a href="#works" class="btn-down"><i class="bi bi-chevron-down"></i></a>
                    <span style="margin-left: 1rem;">Illustration - Design</span>
                </div>
            </div>    
        </div>                          
    </section>
    <section class="works pt-5 pb-3" id="works">
        {{--<div class="titles text-center" id="works">
            <h1 class="sombra">Trabalhos</h1>
            <h1 class="title">Trabalhos</h1>
        </div>--}}
        <div class="col-lg-12 col-md-12 col-sm-12 mt-5 mb-2">
            <div class="container">
                <div class="row">
                    @if(count($data)==0)
                    <div class="col-12 text-center">
                        <h3>@lang('messages.home_content_12')</h3>
                    </div>
                    @else
                        @foreach ($data->take(8) as $item)
                            @if(($loop->index + 1) % 3 == 0)
                            <div class="col-lg-12 col-sm-12 mb-3 fig-container">
                                <a href="{{url('trabalho/'.$item->name_project)}}" title="Clicar para abrir">
                                    <div class="media-container">                                        
                                        @if($item->file_type == "imagem")
                                            <img src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" class="img-fluid rounded-2">
                                        @else
                                            <video autoplay loop muted class="img-fluid rounded-2">
                                                <source src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" type="video/{{ $item->extension_file}}">
                                                Seu navegador não suporta vídeos HTML5.
                                            </video>
                                        @endif                                                                        
                                    </div>  
                                    <div class="media-content">
                                        <h2>{{$item->name_project}}</h2>
                                    </div>                                    
                                </a>                             
                            </div>
                            @else
                            <div class="col-lg-6 col-md-12 col-sm-12 fig-container">
                                <a href="{{url('trabalho/'.$item->name_project)}}" title="Clicar para abrir">
                                    <div class="media-container">                                    
                                        @if($item->file_type == "imagem")
                                            <img src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" class="img-fluid rounded-2">
                                        @else
                                            <video autoplay loop muted class="img-fluid rounded-2">
                                                <source src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" type="video/{{ $item->extension_file}}">
                                                Seu navegador não suporta vídeos HTML5.
                                            </video>
                                        @endif  
                                    </div>                                                                     
                                    <div class="media-content">
                                        <h2>{{$item->name_project}}</h2>
                                    </div>
                                </a>                           
                            </div>
                            @endif
                        @endforeach
                    @endif                        
                </div>
            </div>
        </div>
        <div class="col-12 d-flex justify-content-center">
            @if(count($data)!=0) <a href="{{url('trabalhos')}}" class="bt">@lang('messages.home_content_5')</a> @endif
        </div>
    </section>    
    <section class="newsletter p-5 mb-5">
        <div class="container">
            <div class="d-flex flex-column align-items-center justify-content-center">
                <h2>@lang('messages.home_content_7')</h2>
                <p>@lang('messages.home_content_8')</p>
                <form action="{{route('newsletter')}}" method="post" class="form d-flex flex-column align-items-center">
                    @csrf
                    <input type="email" name="email" required placeholder="E-mail">
                    <button type="submit" class="bt mt-4">@lang('messages.home_content_9')</button>
                </form>
            </div>
        </div>
    </section>
@endsection