@extends('layout.login')
@section('title', 'Entrar - Kamba Animation')
@section('content')                 
    <form action="{{route('login')}}" method="POST">
        @csrf
        @if(session('error'))                        
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        @if($errors->any())                        
            <div class="alert alert-danger p-0 pt-2">
                <ul>
                    @foreach ($errors->all() as $item)
                        <li><i class="bi bi-chevron-right"></i> {{$item}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="mb-3">
            <input type="text" id="user" name="email" placeholder="E-mail">
        </div>
        <div class="mb-3">
            <input type="password" name="password" id="password" placeholder="@lang('messages.login_content_1')">
        </div>
        <div class="mb-3">
            <a href="{{route('resetpassoword')}}">@lang('messages.login_content_2')</a> <br>
        </div>
        <div class="mb-3">
            <button type="submit" class="btn"><i class="bi bi-lock"></i> @lang('messages.login_content_3')</button>
        </div>
    </form>
@endsection