@extends('layout.login')
@section('title', 'Recuperar senha - Kamba Animation')
@section('content')                 
    <div class="mb-4 text-center">
        <h5>@lang('messages.reset_content_1')</h5>
    </div>                         
    {{-- form --}}
    <form action="{{route('resetar')}}" method="post">
        {{-- csrf --}}
        @csrf
        @if(session('error'))                        
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        @if($errors->any())                        
            <div class="alert alert-danger p-0 pt-2">
                <ul>
                    @foreach ($errors->all() as $item)
                        <li><i class="bi bi-chevron-right"></i> {{$item}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="mb-3">
            <input type="email" id="user" placeholder="@lang('messages.reset_content_2')" name="email" required>
        </div>
        <div class="mb-4">
            <button type="submit" class="btn"><i class="bi bi-send"></i>@lang('messages.reset_content_3')</button>
        </div>
        <div class="mb-3 text-center">
            @lang('messages.reset_content_4')&ensp;&ensp;
            <a href="/login">@lang('messages.reset_content_5')</a>
        </div>
    </form>
    {{-- endforma --}}
@endsection