@extends('layout.main')
@section('title','Kamba Animation')
@section('content')    
    <section class="works ma-top pb-5" id="works">
        <div class="container">
            <div class="col-12 ma-top">
                @if($project->file_type == "imagem")
                    <img src="{{ asset('storage/uploads/project_'.$project->idProject.'/'.$project->thumb) }}" class="img-fluid rounded-2">
                @else
                    <video autoplay loop muted class="img-fluid rounded-2">
                        <source src="{{ asset('storage/uploads/project_'.$project->idProject.'/'.$project->thumb) }}" type="video/{{ $project->extension_file}}">
                        Seu navegador não suporta vídeos HTML5.
                    </video>
                @endif
            </div>
            <div class="titles text-center mt-5" id="works">
                <h1 class="title">{{ $project->name_project }}</h1>
                <p>{{ $project->description_project }}</p>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 mt-5 mb-5">            
                <div class="row">
                    @if($data->count() == 0)
                    <div class="text-center">
                        <h3>@lang('messages.work_content_4')</h3>
                    </div>
                    @else
                        @foreach ($data as $item)
                            @if(($loop->index + 1) % 3 == 0)
                            <div class="col-lg-12 col-sm-12 mb-3 fig-container">
                                <a href="#capa{{$item->idFile}}" data-bs-toggle="modal" data-bs-target="#capa{{$item->idFile}}" title="Clicar para abrir">
                                    <div class="media-container">                                        
                                        @if($item->file_type2 == "imagem")
                                            <img src="{{ asset('storage/uploads/project_'.$item->project_id.'/'.$item->file) }}" class="img-fluid rounded-2">
                                        @else
                                            <video autoplay loop muted class="img-fluid rounded-2">
                                                <source src="{{ asset('storage/uploads/project_'.$item->project_id.'/'.$item->file) }}" type="video/{{ $item->extension_file2}}">
                                                Seu navegador não suporta vídeos HTML5.
                                            </video>
                                        @endif                                                                        
                                    </div>                                   
                                </a>                             
                            </div>
                            @else
                            <div class="col-lg-6 col-md-6 col-sm-12 mb-3 fig-container">
                                <a href="#capa{{$item->idFile}}" data-bs-toggle="modal" data-bs-target="#capa{{$item->idFile}}" title="Clicar para abrir">
                                    <div class="media-container">                                    
                                        @if($item->file_type2 == "imagem")
                                            <img src="{{ asset('storage/uploads/project_'.$item->project_id.'/'.$item->file) }}" class="img-fluid rounded-2">
                                        @else
                                            <video autoplay loop muted class="img-fluid rounded-2">
                                                <source src="{{ asset('storage/uploads/project_'.$item->project_id.'/'.$item->file) }}" type="video/{{ $item->extension_file2}}">
                                                Seu navegador não suporta vídeos HTML5.
                                            </video>
                                        @endif  
                                    </div>           
                                </a>                           
                            </div>
                            @endif

                            <div class="modal fade" id="capa{{$item->idFile}}" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                <div class="modal-dialog  modal-xl">
                                    <div class="modal-content">                                            
                                        @if($item->file_type2 == 'imagem')
                                        <img src="{{asset('storage/uploads/project_'.$item->project_id.'/'.$item->file)}}" class="img-fluid">
                                        @else
                                        <video id="background-video" autoplay controls muted>
                                            <source src="{{asset('storage/uploads/project_'.$item->project_id.'/'.$item->file)}}" type="video/{{$item->extension_file2}}">
                                            Seu navegador não suporta vídeos HTML5.
                                        </video>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif                        
                </div>
            </div>        
        </div>
    </section>
@endsection