@extends('layout.main')
@section('title','Kamba Animation')
@section('content')   
    <div class="banner-2">
        <div class="text-center p-5">
            <h1>@lang('messages.work_content_1')</h1>
            <p>@lang('messages.work_content_2')</p>      
        </div>          
    </div> 
    <section class="categories mt-5">
        <div class="container">
            <div class="col-9 m-auto text-center">
                @if(empty($categories))
                    <div class="p-5 text-center">
                        <h4>@lang('messages.work_content_3')</h4>
                    </div>
                @else
                <div class="list-categories">
                    @foreach ($categories as $item)
                        <a href="{{url('trabalhos/'.$item->category)}}" class="badge text-bg-warning">{{$item->category}}</a>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
    </section>
    <section class="works pt-3 pb-5" id="works">
        {{--<div class="titles text-center" id="works">
            <h1 class="sombra">Trabalhos</h1>
            <h1 class="title">Trabalhos</h1>
        </div>--}}
        <div class="col-lg-12 col-md-12 col-sm-12 mt-5 mb-5">
            <div class="container">
                <div class="row">
                    @if(empty($data))
                    <div class="text-center">
                        <h3>@lang('messages.work_content_4')</h3>
                    </div>
                    @else
                        @foreach ($data->take(8) as $item)
                            @if(($loop->index + 1) % 3 == 0)
                            <div class="col-lg-12 col-sm-12 mb-3 fig-container">
                                <a href="{{url('trabalho/'.$item->name_project)}}" title="Clicar para abrir">
                                    <div class="media-container">                                        
                                        @if($item->file_type == "imagem")
                                            <img src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" class="img-fluid rounded-2">
                                        @else
                                            <video autoplay loop muted class="img-fluid rounded-2">
                                                <source src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" type="video/{{ $item->extension_file}}">
                                                Seu navegador não suporta vídeos HTML5.
                                            </video>
                                        @endif                                                                        
                                    </div>  
                                    <div class="media-content">
                                        <h2>{{$item->name_project}}</h2>
                                    </div>                                    
                                </a>                             
                            </div>
                            @else
                            <div class="col-lg-6 col-md-6 col-sm-12 mb-3 fig-container">
                                <a href="{{url('trabalho/'.$item->name_project)}}" title="Clicar para abrir">
                                    <div class="media-container">                                    
                                        @if($item->file_type == "imagem")
                                            <img src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" class="img-fluid rounded-2">
                                        @else
                                            <video autoplay loop muted class="img-fluid rounded-2">
                                                <source src="{{ asset('storage/uploads/project_'.$item->idProject.'/'.$item->thumb) }}" type="video/{{ $item->extension_file}}">
                                                Seu navegador não suporta vídeos HTML5.
                                            </video>
                                        @endif  
                                    </div>                                                                     
                                    <div class="media-content">
                                        <h2>{{$item->name_project}}</h2>
                                    </div>
                                </a>                           
                            </div>
                            @endif
                        @endforeach
                    @endif                        
                </div>
            </div>
        </div>
    </section>   
</diV>
@endsection