@extends('layout.login')
@section('title', 'Entrar - Kamba Animation')
@section('content')                 
    <form action="{{route('otp_check')}}" method="POST">
        @csrf
        @if(session('error'))                        
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        @if($errors->any())                        
            <div class="alert alert-danger p-0 pt-2">
                <ul>
                    @foreach ($errors->all() as $item)
                        <li><i class="bi bi-chevron-right"></i> {{$item}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="mb-3">
            <label for="user" class="mb-2">@lang('messages.contact_content_11')</label>            
            <input type="text" id="user" name="otp" placeholder="Código">
        </div>
        <div class="mb-3">
            <button type="submit" class="btn"><i class="bi bi-lock"></i> @lang('messages.contact_content_12')</button>
        </div>
    </form>
@endsection