<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    {{-- SEO Meta Tags --}}
    <meta name="author" content="GROUP ITCORE">
    <meta name="keywords" content="{{env('APP_KEYWORDS')}}">
    <meta name="description" content="{{env('APP_DESCRIPTION')}}">
    <meta property="og:title" content="{{env('APP_NAME')}}">
    <meta property="og:description" content="{{env('APP_DESCRIPTION')}}">
    
    {{-- Open Graph Meta Tags --}}
    <meta property="og:title" content="Kamba Animation">
    <meta property="og:description" content="{{env('APP_DESCRIPTION')}}">
    <meta property="og:url" content="https://kambaanimation.com">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://kambaanimation.com/assets/img/ka_capa.png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="660">
    <meta property="og:site_name" content="{{env('APP_NAME')}}">

    {{-- Twitter Meta Tags --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{env('APP_NAME')}}">
    <meta name="twitter:description" content="{{env('APP_DESCRIPTION')}}">
    <meta name="twitter:image" content="https://kambaanimation.com/assets/img/ka_capa.png">

    <title>@yield('title')</title>
    <link rel="shortcut icon" href="{{ asset('public/assets/img/favicon.png') }}" type="image/x-icon">
    
    @vite('resources/assets/css/app2.css')
    <script src="{{ asset('assets/js/sweetalert2.all.min.js') }}"></script>
    <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>

    <script src="{{ asset('assets/js/sweetalert2.all.min.js') }}"></script>
    <script src="{{ asset('assets/tinymce/tinymce.min.js') }}"></script>
    <script src="{{ asset('assets/tinymce/langs/pt_BR.js') }}"></script>

    <script src="{{ asset('assets/simple-datatables/simple-datatables.js') }}"></script>
    <script src="{{ asset('assets/simple-datatables/admin.js') }}"></script>

    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
</head>

<body>
    <header id="header" class="header fixed-top d-flex align-items-center">
        <div class="d-flex align-items-center justify-content-between">
            <a href="{{url('dashboard')}}" class="logo d-flex align-items-center">
                <img src="{{ asset('assets/img/logo.png') }}" alt="">
            </a>
            <i class="bi bi-list toggle-sidebar-btn"></i>
        </div>
        <nav class="header-nav ms-auto">
            <ul class="d-flex align-items-center">
                <li class="nav-item dropdown pe-3">
                    <a class="nav-link collapsed nav-profile d-flex align-items-center pe-0" href="#"
                        data-bs-toggle="dropdown">
                        @if (Auth::user()->thumb == 'default')
                            <img src="{{ asset('assets/img/avatar.png') }}" class="img-thumbnail" style="border-radius: 50px;" alt="Foto de perfil">
                        @else
                            <img src="{{ asset('storage/avatar/' . Auth::user()->thumb) }}"
                                style="border-radius: 50%; border:thin solid #fff; box-shadow: 0 10px 10px 0 rgba(0,0,0,.1); width: 40px; height: 40px;"
                                alt="">
                        @endif
                        <span class="d-none d-md-block dropdown-toggle ps-2">
                            {{ explode(' ', Auth::user()->name)[0] }}
                        </span>
                    </a><!-- End Profile Iamge Icon -->

                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                        <li class="dropdown-header">
                            <h6> {{ explode(' ', Auth::user()->name)[0] }} </h6>
                            <span>
                                @switch(Auth::user()->level)
                                    @case(10)
                                        Master
                                        @break
                                    @case(11)
                                        Administrador(a)
                                        @break
                                    @default
                                        Normal
                                @endswitch
                            </span>
                        </li>
                        <li>
                            <hr class="dropdown-divider">
                        </li>

                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="{{route('perfil')}}">
                                <i class="bi bi-person"></i>
                                <span>Meu Perfil</span>
                            </a>
                        </li>

                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="{{ route('logout') }}">
                                <i class="bi bi-box-arrow-right"></i>
                                <span>Sair</span>
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </nav>

    </header>

    <aside id="sidebar" class="sidebar">
        <ul class="sidebar-nav" id="sidebar-nav">
            <li class="nav-item">
                <a class="nav-link {{ Request::is('dashboard') ? '' : 'collapsed' }}" href="{{url('dashboard')}}">
                    <i class="bi bi-grid"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ Request::is('/') ? '' : 'collapsed' }}" href="{{url('/')}}">
                    <i class="bi bi-layout-sidebar-inset"></i>
                    <span>Site Inicial</span>
                </a>
            </li>

            <li class="nav-heading">Páginas</li>

            <li class="nav-item">
                <a class="nav-link {{ (Request::is('projectos') or Request::is('projectos/novo-projecto') or Request::is('projectos/adicionais/*')) ? '':'collapsed' }}" href="{{url('projectos')}}">
                    <i class="bi bi-tag"></i>
                    <span>Projectos</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link {{ (Request::is('team') or Request::is('team/*')) ? '':'collapsed' }}" href="{{route('team')}}">
                    <i class="bi bi-tag"></i>
                    <span>Team</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link {{ (Request::is('newsletters')) ? '':'collapsed' }}" href="{{url('newsletters')}}">
                    <i class="bi bi-envelope"></i>
                    <span>Newsletter</span>
                </a>
            </li>
            
            <li class="nav-heading">Sistema</li>
            @if( Auth::user()->level != 12 )
            <li class="nav-item">
                <a class="nav-link {{ (Request::is('utilizadores') or Request::is('utilizadores/novo-utilizador')) ? '':'collapsed' }}" href="{{url('utilizadores')}}">
                    <i class="bi bi-person"></i>
                    <span>Utilizadores</span>
                </a>
            </li>
            @endif

            <li class="nav-item">
                <a class="nav-link {{ Request::is('sistema') ? '':'collapsed' }}" href="{{route('sistema')}}">
                    <i class="bi bi-gear"></i>
                    <span>Sistema</span>
                </a>
            </li>

            @if( Auth::user()->level != 12)
            <li class="nav-item">
                <a class="nav-link {{ Request::is('logs') ? '':'collapsed' }}" href="{{route('logs')}}">
                    <i class="bi bi-clock-history"></i>
                    <span>Logs</span>
                </a>
            </li>
            @endif;
        </ul>

    </aside>

    <main id="main" class="main">
        @yield('content')
    </main>

    <footer id="footer" class="footer p-5 pt-3 pb-3">
        Kamba Animation v1.0 - Desenvolvido Por: <a href="http://itcore.ao" target="_blank">ITCORE</a>
    </footer>

    <script src="{{ asset('assets/js/admin.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.js') }}"></script>
    <script src="{{ asset('assets/bootstrap/js/bootstrap.bundle.js') }}"></script>
    @yield('script')    
    @include('layout.alert')
</body>

</html>
