<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
   {{-- SEO Meta Tags --}}
    <meta name="author" content="GROUP ITCORE">
    <meta name="keywords" content="{{env('APP_KEYWORDS')}}">
    <meta name="description" content="{{env('APP_DESCRIPTION')}}">
    <meta property="og:title" content="{{env('APP_NAME')}}">
    <meta property="og:description" content="{{env('APP_DESCRIPTION')}}">
    
    {{-- Open Graph Meta Tags --}}
    <meta property="og:title" content="Kamba Animation">
    <meta property="og:description" content="{{env('APP_DESCRIPTION')}}">
    <meta property="og:url" content="https://kambaanimation.com">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://kambaanimation.com/assets/img/ka_capa.png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="660">
    <meta property="og:site_name" content="{{env('APP_NAME')}}">

    {{-- Twitter Meta Tags --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{env('APP_NAME')}}">
    <meta name="twitter:description" content="{{env('APP_DESCRIPTION')}}">
    <meta name="twitter:image" content="https://kambaanimation.com/assets/img/ka_capa.png">

    <title>@yield('title')</title>
    <link rel="shortcut icon" href="{{ asset('public/assets/img/favicon.png') }}" type="image/x-icon">
    
    <link rel="stylesheet" href="{{ asset('assets/bootstrap/icons/bootstrap-icons.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/bootstrap/css/bootstrap.min.css') }}">
    <link href="{{ asset('assets/css/sweetalert2.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <script src="https://unpkg.com/scrollreveal"></script>
    <script src="{{asset('assets/js/sweetalert2.all.min.js')}}"></script>
    <script src="{{asset('assets/js/sweetalert2@11.js')}}"></script>  
</head>

<body>
    <div class="auth p-3">
        <div class="mb-5 text-center">
            <a href="{{ url('/') }}">
                <img src="{{asset('assets/img/logo_white.png')}}" alt=""> 
            </a>
        </div>       
        @yield('content')
    </div>    
    <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/bootstrap/js/bootstrap.misn.js') }}"></script>
    <script src="{{ asset('assets/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/default.js') }}"></script>
    @if (session('status'))
        @if (session('status')=='success')
        <script> Swal.fire({ position: 'center',title: 'Successo!',icon: 'success',text: '{{session("msg")}}',showConfirmButton: true,confirmButtonText: 'OK',timer: 10000, confirmButtonColor:'#1FA245',backdrop: `rgba(31, 162, 69,0.4)` }) </script>
        @else
        <script> Swal.fire({ position: 'center', title: 'Erro!', icon: 'error', text: '{{session("msg")}}', showConfirmButton: true, confirmButtonText: 'OK', timer: 10000, confirmButtonColor:'#ED1C24', backdrop: `rgba(237,28,36,0.4)` }) </script> 
        @endif
    @endif
</body>

</html>
