<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">    
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    {{-- SEO Meta Tags --}}
    <meta name="author" content="GROUP ITCORE">
    <meta name="keywords" content="{{env('APP_KEYWORDS')}}">
    <meta name="description" content="{{env('APP_DESCRIPTION')}}">
    <meta property="og:title" content="{{env('APP_NAME')}}">
    <meta property="og:description" content="{{env('APP_DESCRIPTION')}}">
    
    {{-- Open Graph Meta Tags --}}
    <meta property="og:title" content="Kamba Animation">
    <meta property="og:description" content="{{env('APP_DESCRIPTION')}}">
    <meta property="og:url" content="https://kambaanimation.com">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://kambaanimation.com/assets/img/ka_capa.png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="660">
    <meta property="og:site_name" content="{{env('APP_NAME')}}">

    {{-- Twitter Meta Tags --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{env('APP_NAME')}}">
    <meta name="twitter:description" content="{{env('APP_DESCRIPTION')}}">
    <meta name="twitter:image" content="https://kambaanimation.com/assets/img/ka_capa.png">

    <title>@yield('title')</title>
    <link rel="shortcut icon" href="{{ asset('public/assets/img/favicon.png') }}" type="image/x-icon">
    
    @vite('resources/assets/css/app.css')
    <script src="{{ asset('assets/js/sweetalert2.all.min.js') }}"></script>
    <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>

    <script src="{{ asset('assets/js/sweetalert2.all.min.js') }}"></script>
    <script src="https://unpkg.com/scrollreveal"></script>
</head>

<body id="home">
    <div id="preloader">
        <img src="{{asset('assets/img/load.gif')}}" class="v_load">
    </div>
    <nav class="menu">
        <div class="container d-flex align-items-center">
            <div class="d-flex pt-2 pb-2">
                <div class="navbar-left d-flex align-items-center">
                    <a class="navbar-brand" href="/"><img src="{{ asset('assets/img/logo_white.png') }}"
                            alt=""></a>
                </div>
                <div class="navbar-right" id="navbar">
                    <button id="close"><i class="bi bi-x-circle"></i></button>
                    <ul class="d-flex justify-content-end align-items-center">
                        <li><a class="nav-link" href="/#works">@lang('messages.home_content_2')</a></li>
                        <li><a class="nav-link" href="{{ url('about') }}">@lang('messages.home_content_1')</a></li>
                        <li><a class="nav-link" href="{{ url('contact') }}">@lang('messages.home_content_4')</a></li>    
                        <li>
                            <div class="dropdown">
                                <a class="btn dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                  @if(app()->getLocale() == 'pt') <img src="{{ asset('assets/img/flag/pt.png') }}" width="20" title="Português"> PT @else <img src="{{ asset('assets/img/flag/en-us.png') }}" width="20" title="Inglês"> EN @endif
                                </a>
                              
                                <ul class="dropdown-menu">
                                    <li>
                                        <a class="dropdown-item" href="{{ url(app()->getLocale() == 'pt' ? 'locale/en' : 'locale/pt')}}">
                                            @if(app()->getLocale() == 'en') <img src="{{ asset('assets/img/flag/pt.png') }}" width="20" title="Português"> PT @else <img src="{{ asset('assets/img/flag/en-us.png') }}" width="20" title="Inglês"> EN @endif
                                        </a>
                                    </li>                                  
                                </ul>
                              </div>
                        </li>                                                                    
                    </ul>
                </div>
                <button class="navbar-toggler" id="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                    aria-label="Toggle navigation">
                    <i class="bi bi-grid-fill"></i>
                </button>
            </div>            
        </div>
    </nav>
    <div class="interface mb-5">
        @yield('content')
    </div>
    <footer class="mt-5">
        <div class="d-flex justify-content-center align-items-center">
            <div class="pulsar">
                <a href="#home"><i class="bi bi-chevron-up"></i></a>
            </div>
        </div>
        <div class="container pt-3 pb-3">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <p>
                        Kamba Animation Studios @php date('Y') @endphp - @lang('messages.home_content_10') 
                        <a href="http://kwacp.ao" target="_blank" rel="noopener noreferrer">Kwacp</a>
                    </p>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 d-flex justify-content-end social-midia">
                    <a target="_blank" href="https://www.linkedin.com/company/kamba-animation/"><i class="bi bi-linkedin"></i></a>
                    <a target="_blank" href="https://www.instagram.com/kamba.animation/"><i class="bi bi-instagram"></i></a>
                    <a target="_blank" href="https://vimeo.com/user94014789"><i class="bi bi-vimeo"></i></a>
                    <a target="_blank" href="https://www.behance.net/kambaanimae517"><i class="bi bi-behance"></i></a>
                </div>
            </div>
        </div>
    </footer>
    <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/bootstrap/js/bootstrap.misn.js') }}"></script>
    <script src="{{ asset('assets/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/default.js') }}"></script>
    @include('layout.alert')
</body>

</html>
