<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\ConfigurationController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\LocaleController;
use App\Http\Controllers\LogController;
use App\Http\Controllers\MainController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\SystemController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('locale/{lang}', [LocaleController::class, 'setLocale']);

Route::get('/', [MainController::class, 'index'])->name('index');
Route::get('autenticacao-dois-factores', [AuthController::class, 'auth_2fa'])->name('verify');
Route::post('autenticacao-dois-factores', [AuthController::class, 'otp_check'])->name('otp_check');
Route::view('expiracao', 'home.expire')->name('expire');
Route::get('reset', [MainController::class, 'reset'])->name('resetpassoword');
Route::post('resetar', [UserController::class, 'resetar'])->name('resetar');
Route::get('contact', [ContactController::class, 'index'])->name('contact');
Route::get('about', [MainController::class, 'about'])->name('about');

Route::post('newsletter', [NewsletterController::class, 'store'])->name(name: 'newsletter');
Route::post('send-mail', [ContactController::class, 'store'])->name(name: 'send-mail');
Route::get('newsletter/cancelar/{email}', [NewsletterController::class, 'update'])->name(name: 'cancel.newsletter');

Route::get('login', [AuthController::class, 'index'])->name('login');
Route::post('login', [AuthController::class, 'login'])->name('login');

Route::get('trabalho/{id}', [MainController::class, 'work'])->name('trabalho');
Route::get('trabalhos', [MainController::class, 'works'])->name('trabalhos');
Route::get('trabalhos/{category}', [MainController::class, 'categoriesWork'])->name('trabalhos-categoria');


Route::middleware(['auth'])->group(function(){
    Route::get('logout', [AuthController::class, 'logout'])->name('logout');
    
    Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard'); 
    Route::delete('newsletter/{id}', [NewsletterController::class, 'destroy'])->name('eliminar-newsletter');
    Route::get('newsletters', [NewsletterController::class, 'index'])->name('newsletters');
    Route::post('newsletters', [NewsletterController::class, 'index'])->name('newsletters');

    // Team Members
    Route::get('team', [TeamController::class, 'index'])->name('team');
    Route::get('team/novo-membro', [TeamController::class, 'create'])->name('novo.membro');
    Route::get('team/editar-membro/{id}', [TeamController::class, 'edit'])->name('editar.membro');
    Route::post('novo-membro', [TeamController::class, 'store'])->name('registar.membro');
    Route::put('editar-membro/{id}', [TeamController::class, 'update'])->name('update.membro');
    Route::delete('eliminar-membro/{id}', [TeamController::class, 'destroy'])->name('eliminar.membro');

    Route::get('perfil', [ConfigurationController::class, 'index'])->name('perfil');
    Route::get('sistema', [SystemController::class, 'index'])->name('sistema');
    Route::put('sistema/{id}', [SystemController::class, 'update'])->name('sistema.update');
    Route::put('sistema/en/{id}', [SystemController::class, 'updateEn'])->name('sistema.updateen');    
    Route::post('sistema/imagem', [SystemController::class, 'addImage'])->name('sistema.image');
    Route::delete('sistema/imagem/{id}', [SystemController::class, 'destroyImage'])->name('sistema.delete.image');

    Route::put('profile', [ConfigurationController::class, 'updateProfile'])->name('perfil.edit');
    Route::put('authentication', [ConfigurationController::class, 'authentication'])->name('perfil.auth');
    Route::put('password', [ConfigurationController::class, 'password'])->name('perfil.password');

    Route::post('rede-social', [ConfigurationController::class, 'socialMidia'])->name('rede-social');
    Route::put('rede-social/editar/{id}', [ConfigurationController::class, 'update'])->name('social.edit');
    Route::delete('rede-social/{id}', [ConfigurationController::class, 'destroySocialMidia'])->name('social.delete');


    Route::get('projectos', [ProjectController::class, 'index'])->name('projectos');
    Route::get('projectos/novo-projecto', [ProjectController::class, 'create'])->name('novo-projecto');
    Route::get('projectos/editar/{id}', [ProjectController::class, 'edit'])->name('editar-projecto');
    Route::post('projectos/novo-projecto', [ProjectController::class, 'store'])->name('registar-projecto');
    Route::put('projectos/projecto/{id}', [ProjectController::class, 'update'])->name('editar-projecto');
    Route::delete('projectos/projecto/{id}', [ProjectController::class, 'destroy'])->name('eliminar-projecto');

    Route::get('projectos/adicionais/{id}', [FileController::class, 'show'])->name('imagens');
    Route::post('projectos/adicionais', [FileController::class, 'store'])->name('registar-adicional');
    Route::delete('projectos/adicionais/{id}', [FileController::class, 'destroy'])->name('eliminar-adicional');
    

    Route::middleware(['admin'])->group(function(){
        Route::get('logs', [LogController::class, 'index'])->name('logs');
    
        Route::get('utilizadores', [UserController::class, 'index'])->name('utilizadores');
        Route::get('utilizadores/novo-utilizador', [UserController::class, 'create'])->name('novo-utilizador');
        Route::get('utilizadores/novo-utilizador/{id}', [UserController::class, 'show'])->name('novo-utilizador');
        Route::get('utilizadores/resetar/{id}', [UserController::class, 'reset'])->name('reset');
    
        Route::post('utilizadores/novo-utilizador', [UserController::class, 'store'])->name('registar-utilizador');
        Route::delete('utilizadores/{id}', [UserController::class, 'destroy'])->name('eliminar-utilizador');
        //Route::put('utilizadores/{id}', [UserController::class, 'update'])->name('editar-utilizador');
        Route::put('utilizadores/conta/{id}', [UserController::class, 'update'])->name('editar-estado');
    });

});