<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <meta name="author" content="GROUP ITCORE">
    <meta name="keywords" content="<?php echo e(env('APP_KEYWORDS')); ?>">
    <meta name="description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    <meta property="og:title" content="<?php echo e(env('APP_NAME')); ?>">
    <meta property="og:description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    
    
    <meta property="og:title" content="Kamba Animation">
    <meta property="og:description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    <meta property="og:url" content="https://kambaanimation.com">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://kambaanimation.com/assets/img/ka_capa.png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="660">
    <meta property="og:site_name" content="<?php echo e(env('APP_NAME')); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e(env('APP_NAME')); ?>">
    <meta name="twitter:description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    <meta name="twitter:image" content="https://kambaanimation.com/assets/img/ka_capa.png">

    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('public/assets/img/favicon.png')); ?>" type="image/x-icon">
    
    <?php echo app('Illuminate\Foundation\Vite')('resources/assets/css/app2.css'); ?>
    <script src="<?php echo e(asset('assets/js/sweetalert2.all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sweetalert2@11.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/sweetalert2.all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/tinymce/tinymce.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/tinymce/langs/pt_BR.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/simple-datatables/simple-datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/simple-datatables/admin.js')); ?>"></script>

    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
</head>

<body>
    <header id="header" class="header fixed-top d-flex align-items-center">
        <div class="d-flex align-items-center justify-content-between">
            <a href="<?php echo e(url('dashboard')); ?>" class="logo d-flex align-items-center">
                <img src="<?php echo e(asset('assets/img/logo.png')); ?>" alt="">
            </a>
            <i class="bi bi-list toggle-sidebar-btn"></i>
        </div>
        <nav class="header-nav ms-auto">
            <ul class="d-flex align-items-center">
                <li class="nav-item dropdown pe-3">
                    <a class="nav-link collapsed nav-profile d-flex align-items-center pe-0" href="#"
                        data-bs-toggle="dropdown">
                        <?php if(Auth::user()->thumb == 'default'): ?>
                            <img src="<?php echo e(asset('assets/img/avatar.png')); ?>" class="img-thumbnail" style="border-radius: 50px;" alt="Foto de perfil">
                        <?php else: ?>
                            <img src="<?php echo e(asset('storage/avatar/' . Auth::user()->thumb)); ?>"
                                style="border-radius: 50%; border:thin solid #fff; box-shadow: 0 10px 10px 0 rgba(0,0,0,.1); width: 40px; height: 40px;"
                                alt="">
                        <?php endif; ?>
                        <span class="d-none d-md-block dropdown-toggle ps-2">
                            <?php echo e(explode(' ', Auth::user()->name)[0]); ?>

                        </span>
                    </a><!-- End Profile Iamge Icon -->

                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                        <li class="dropdown-header">
                            <h6> <?php echo e(explode(' ', Auth::user()->name)[0]); ?> </h6>
                            <span>
                                <?php switch(Auth::user()->level):
                                    case (10): ?>
                                        Master
                                        <?php break; ?>
                                    <?php case (11): ?>
                                        Administrador(a)
                                        <?php break; ?>
                                    <?php default: ?>
                                        Normal
                                <?php endswitch; ?>
                            </span>
                        </li>
                        <li>
                            <hr class="dropdown-divider">
                        </li>

                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('perfil')); ?>">
                                <i class="bi bi-person"></i>
                                <span>Meu Perfil</span>
                            </a>
                        </li>

                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('logout')); ?>">
                                <i class="bi bi-box-arrow-right"></i>
                                <span>Sair</span>
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </nav>

    </header>

    <aside id="sidebar" class="sidebar">
        <ul class="sidebar-nav" id="sidebar-nav">
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('dashboard') ? '' : 'collapsed'); ?>" href="<?php echo e(url('dashboard')); ?>">
                    <i class="bi bi-grid"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('/') ? '' : 'collapsed'); ?>" href="<?php echo e(url('/')); ?>">
                    <i class="bi bi-layout-sidebar-inset"></i>
                    <span>Site Inicial</span>
                </a>
            </li>

            <li class="nav-heading">Páginas</li>

            <li class="nav-item">
                <a class="nav-link <?php echo e((Request::is('projectos') or Request::is('projectos/novo-projecto') or Request::is('projectos/adicionais/*')) ? '':'collapsed'); ?>" href="<?php echo e(url('projectos')); ?>">
                    <i class="bi bi-tag"></i>
                    <span>Projectos</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link <?php echo e((Request::is('team') or Request::is('team/*')) ? '':'collapsed'); ?>" href="<?php echo e(route('team')); ?>">
                    <i class="bi bi-tag"></i>
                    <span>Team</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link <?php echo e((Request::is('newsletters')) ? '':'collapsed'); ?>" href="<?php echo e(url('newsletters')); ?>">
                    <i class="bi bi-envelope"></i>
                    <span>Newsletter</span>
                </a>
            </li>
            
            <li class="nav-heading">Sistema</li>
            <?php if( Auth::user()->level != 12 ): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((Request::is('utilizadores') or Request::is('utilizadores/novo-utilizador')) ? '':'collapsed'); ?>" href="<?php echo e(url('utilizadores')); ?>">
                    <i class="bi bi-person"></i>
                    <span>Utilizadores</span>
                </a>
            </li>
            <?php endif; ?>

            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('sistema') ? '':'collapsed'); ?>" href="<?php echo e(route('sistema')); ?>">
                    <i class="bi bi-gear"></i>
                    <span>Sistema</span>
                </a>
            </li>

            <?php if( Auth::user()->level != 12): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(Request::is('logs') ? '':'collapsed'); ?>" href="<?php echo e(route('logs')); ?>">
                    <i class="bi bi-clock-history"></i>
                    <span>Logs</span>
                </a>
            </li>
            <?php endif; ?>;
        </ul>

    </aside>

    <main id="main" class="main">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <footer id="footer" class="footer p-5 pt-3 pb-3">
        Kamba Animation v1.0 - Desenvolvido Por: <a href="http://itcore.ao" target="_blank">ITCORE</a>
    </footer>

    <script src="<?php echo e(asset('assets/js/admin.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/bootstrap/js/bootstrap.bundle.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>    
    <?php echo $__env->make('layout.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH C:\laragon\www\kambaanimation\resources\views/layout/dashboard.blade.php ENDPATH**/ ?>