
<?php $__env->startSection('title', 'Novo projecto - Kamba Animation'); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Novo projecto</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('projectos')); ?>">Projectos</a></li>
                <li class="breadcrumb-item active">Adicionar itens</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-5">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <form enctype="multipart/form-data" action="<?php echo e(route('registar-adicional')); ?>" method="post" class="form">
                            <?php echo csrf_field(); ?>
                            <div class="row">                                
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="row">                                        
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Ficheiro</label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Seleciona um ficheiro</label>
                                            <input type="text" hidden name="id" value="<?php echo e($id); ?>">
                                            <input type="file" hidden name="file" id="file" class="fileInput">
                                            <input type="text" hidden name="file_type" required class="file_type">
                                        </div>
                                        <div class="col-lg-12 mt-3">
                                            <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                        </div>
                                    </div>
                                </div> 
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer"></div>                               
                            </div>
                        </form>
                        <hr>
                        <strong>Total de adicionais</strong> " <?php echo e($total); ?> "
                        <div class="row mt-5">
                            <?php if(empty($data)): ?>
                                <div class="col-12 p-5 text-center">
                                    <h3 class="text-muted">Sem itens adicionais</h3>
                                </div>
                            <?php else: ?>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-4 col-md-4 col-sm-12 mb-5">
                                        <div class="media-container">
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#capa<?php echo e($item->idFile); ?>" title="Clicar para abrir">
                                                <?php if($item->file_type2 == "imagem"): ?>
                                                    <img src="<?php echo e(asset('storage/uploads/project_'.$id.'/'.$item->file)); ?>" class="img-fluid rounded-2">
                                                <?php else: ?>
                                                    <video controls muted class="img-fluid rounded-2">
                                                        <source src="<?php echo e(asset('storage/uploads/project_'.$id.'/'.$item->file)); ?>" type="video/<?php echo e($item->extension_file2); ?>">
                                                        Seu navegador não suporta vídeos HTML5.
                                                    </video>
                                                <?php endif; ?>  
                                            </a>                                            
                                        </div>  
                                        <div class="media-container-bottom pt-2">
                                            <a href="#" class="text-danger" type="button" data-bs-toggle="modal" data-bs-target="#delete<?php echo e($item->idFile); ?>"><i class="bi bi-trash"></i> Eliminar</a>
                                        </div>                                   
                                    </div>

                                    <div class="modal fade" id="delete<?php echo e($item->idFile); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                          <div class="modal-content">                                              
                                            <div class="modal-body text-center">
                                                <h5>Deseja eliminar este ficheiro?</h5>
                                                <form action="<?php echo e(route('eliminar-adicional',$item->idFile)); ?>" method="POST">
                                                    <?php echo method_field('DELETE'); ?>;
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-danger">Sim</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                </form>
                                            </div>
                                          </div>
                                        </div>
                                    </div>
                                    <div class="modal fade" id="capa<?php echo e($item->idFile); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog  modal-xl">
                                          <div class="modal-content">                                            
                                                <?php if($item->file_type2 == 'imagem'): ?>
                                                <img src="<?php echo e(asset('storage/uploads/project_'.$id.'/'.$item->file)); ?>" class="img-fluid">
                                                <?php else: ?>
                                                <video autoplay controls muted>
                                                    <source src="<?php echo e(asset('storage/uploads/project_'.$id.'/'.$item->file)); ?>" type="video/<?php echo e($item->extension_file2); ?>">
                                                    Seu navegador não suporta vídeos HTML5.
                                                  </video>
                                                <?php endif; ?>
                                          </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/default-admin.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kambaanimation\resources\views/admin/projects/addImages.blade.php ENDPATH**/ ?>