
<?php $__env->startSection('title', 'Utilizadores - Kamba Animation'); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Utilizadores</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Utilizadores</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="col col-12 d-flex justify-content-end mb-3">
            <a href="/utilizadores/novo-utilizador" class="btn btn-success btn-sm">
                <i class="bi bi-plus-lg"></i> Novo Utilizador
            </a>

        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger mb-5">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th scope="col"></th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Nível</th>
                                    <th scope="col">Estado</th>
                                    <th scope="col"></th>
                                </tr>
                            </thead>
                            <tbody class="tbody-center">
                                <?php if($data->count()==0): ?>
                                <tr>
                                    <td colspan="7" rows="7">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-person"></i></h1>
                                            <h3> Não existem registos</h3>
                                        </div>
                                    </td>
                                </tr>
                                <?php else: ?>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php if($item->thumb == "default"): ?>
                                            <img src="<?php echo e(asset('assets/img/avatar.png')); ?>" class="rounded-5 img-thumbnail" width="50" height="50" alt="">
                                            <?php else: ?>
                                            <img src="<?php echo e(asset('storage/avatar/'.$item->thumb)); ?>" type="button" data-bs-toggle="modal" data-bs-target="#capa<?php echo e($item->id); ?>" class="rounded-5 img-thumbnail" width="50" height="50" alt="">
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->name); ?></td>
                                        <td><?php echo e($item->email); ?></td>
                                        <td>
                                            <?php if($item->level == "11"): ?>
                                                Adminstrador
                                            <?php else: ?>
                                                Normal
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($item->status_user=='1'): ?>
                                                <h6><span class="badge rounded-pill text-bg-success">Activo</span></h6>                                                
                                            <?php else: ?>
                                                <h6><span class="badge rounded-pill text-bg-warning">Inactivo</span></h6>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="bi bi-three-dots"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li><a class="dropdown-item" href="#" type="button" data-bs-toggle="modal" data-bs-target="#modal<?php echo e($item->id); ?>"><i class="bi bi-eye"></i> Ver mais</a></li>
                                                    <li><a href="<?php echo e(url('utilizadores/resetar/'.$item->id)); ?>" class="dropdown-item"><i class="bi bi-lock"></i> Resetar P. Passe</a></li>
                                                    <li>
                                                        <a class="dropdown-item" href="#"type="button" data-bs-toggle="modal" data-bs-target="#conta<?php echo e($item->id); ?>"> 
                                                            <?php if($item->status_user==1): ?> 
                                                                <span class="text-danger">
                                                                    <i class="bi bi-person-fill-slash"></i> 
                                                                    Desactivar conta 
                                                                </span>
                                                            <?php else: ?> 
                                                                <span class="text-success"> 
                                                                    <i class="bi bi-person-fill-check"></i> 
                                                                    Activar conta 
                                                                </span> 
                                                            <?php endif; ?>
                                                        </a>
                                                    </li>
                                                    <li><a class="dropdown-item" href="#"type="button" data-bs-toggle="modal" data-bs-target="#delete<?php echo e($item->id); ?>"><i class="bi bi-trash"></i> Eliminar</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                    <div class="modal fade" id="modal<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                          <div class="modal-content">
                                            <div class="modal-header">
                                              <h1 class="modal-title fs-5" id="exampleModalLabel"><?php echo e($item->name); ?></h1>
                                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Nome</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">
                                                                <?php echo e($item->name); ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>E-mail</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">
                                                                <?php echo e($item->email); ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Nível de acesso</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">
                                                                <?php switch($item->level):
                                                                    case (10): ?>
                                                                        Master
                                                                        <?php break; ?>
                                                                    <?php case (11): ?>
                                                                        Administrador(a)
                                                                        <?php break; ?>
                                                                    <?php default: ?>
                                                                        Normal
                                                                <?php endswitch; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3 border-bottom p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Criado aos</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">
                                                                <?php echo e($item->created_at); ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3 p-2">
                                                        <div class="row">
                                                            <div class="col-lg-4 col-sm-12">
                                                                <strong>Estado</strong>
                                                            </div>
                                                            <div class="col-lg-8 col-sm-12">                                                                
                                                                <?php if($item->status_user=='1'): ?>
                                                                    <h6><span class="badge rounded-pill text-bg-success">Activo</span></h6>                                                
                                                                <?php else: ?>
                                                                    <h6><span class="badge rounded-pill text-bg-warning">Inactivo</span></h6>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                              <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Sair</button>
                                            </div>
                                          </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="delete<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">                                            
                                            <div class="modal-body text-center">
                                                <h5>Deseja eliminar esta notificação?</h5>
                                                <form action="<?php echo e(route('eliminar-utilizador',$item->id)); ?>" method="POST">
                                                    <?php echo method_field('DELETE'); ?>;
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-danger">Sim</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                </form>
                                            </div>
                                        </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="conta<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">                                            
                                            <div class="modal-body text-center">
                                                <h5><?php if($item->status_user == 1): ?> Deseja desactivar esta conta? <?php else: ?> Deseja activar esta conta? <?php endif; ?></h5>
                                                <form action="<?php echo e(route('editar-estado',$item->id)); ?>" method="POST">
                                                    <?php echo method_field('PUT'); ?>;
                                                    <?php echo csrf_field(); ?>
                                                    <input type="text" name="status" value="<?php echo e($item->status_user); ?>" hidden>
                                                    <button type="submit" class="btn btn-danger">Sim</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                </form>
                                            </div>
                                        </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="capa<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog  modal-static">
                                          <div class="modal-content">                                            
                                                <img src="<?php echo e(asset('storage/avatar/'.$item->thumb)); ?>" class="img-fluid" alt="<?php echo e($item->name); ?>">
                                          </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<?php echo $__env->make('script.datatable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kambaanimation\resources\views/admin/users/users.blade.php ENDPATH**/ ?>