<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
   
    <meta name="author" content="GROUP ITCORE">
    <meta name="keywords" content="<?php echo e(env('APP_KEYWORDS')); ?>">
    <meta name="description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    <meta property="og:title" content="<?php echo e(env('APP_NAME')); ?>">
    <meta property="og:description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    
    
    <meta property="og:title" content="Kamba Animation">
    <meta property="og:description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    <meta property="og:url" content="https://kambaanimation.com">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://kambaanimation.com/assets/img/ka_capa.png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="660">
    <meta property="og:site_name" content="<?php echo e(env('APP_NAME')); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e(env('APP_NAME')); ?>">
    <meta name="twitter:description" content="<?php echo e(env('APP_DESCRIPTION')); ?>">
    <meta name="twitter:image" content="https://kambaanimation.com/assets/img/ka_capa.png">

    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('public/assets/img/favicon.png')); ?>" type="image/x-icon">
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/bootstrap/icons/bootstrap-icons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/bootstrap/css/bootstrap.min.css')); ?>">
    <link href="<?php echo e(asset('assets/css/sweetalert2.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <script src="https://unpkg.com/scrollreveal"></script>
    <script src="<?php echo e(asset('assets/js/sweetalert2.all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sweetalert2@11.js')); ?>"></script>  
</head>

<body>
    <div class="auth p-3">
        <div class="mb-5 text-center">
            <a href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(asset('assets/img/logo_white.png')); ?>" alt=""> 
            </a>
        </div>       
        <?php echo $__env->yieldContent('content'); ?>
    </div>    
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/bootstrap/js/bootstrap.misn.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/default.js')); ?>"></script>
    <?php if(session('status')): ?>
        <?php if(session('status')=='success'): ?>
        <script> Swal.fire({ position: 'center',title: 'Successo!',icon: 'success',text: '<?php echo e(session("msg")); ?>',showConfirmButton: true,confirmButtonText: 'OK',timer: 10000, confirmButtonColor:'#1FA245',backdrop: `rgba(31, 162, 69,0.4)` }) </script>
        <?php else: ?>
        <script> Swal.fire({ position: 'center', title: 'Erro!', icon: 'error', text: '<?php echo e(session("msg")); ?>', showConfirmButton: true, confirmButtonText: 'OK', timer: 10000, confirmButtonColor:'#ED1C24', backdrop: `rgba(237,28,36,0.4)` }) </script> 
        <?php endif; ?>
    <?php endif; ?>
</body>

</html>
<?php /**PATH C:\laragon\www\kambaanimation\resources\views/layout/login.blade.php ENDPATH**/ ?>