
<?php $__env->startSection('title', 'Novo projecto - Kamba Animation'); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Novo projecto</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('projectos')); ?>">Projectos</a></li>
                <li class="breadcrumb-item active">Novo projecto</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-5">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php if(!isset($project)): ?>
                        <form enctype="multipart/form-data" action="<?php echo e(route('registar-projecto')); ?>" method="post" class="form">
                            <?php echo csrf_field(); ?>
                            <div class="row">                                
                                <div class="col-6">
                                    <div class="row">
                                        <div class="col-12 mb-3">                                            
                                            <label id="category">Categoria <span class="text-danger">*</span></label>
                                            <input type="text" list="lista" name="category" required id="category" placeholder="Informe a categoria do projecto">                                    
                                            <datalist id="lista">
                                                <option value="Animação 2D e 3D">
                                                <option value="Vídeos Promocionais e Publicitários">
                                                <option value="Motion Graphics e Visualização de Dados">
                                                <option value="Vinhetas e Intros">
                                                <option value="Animação de Personagens">
                                                <option value="Efeitos Visuais (VFX)">
                                                <option value="Vídeos Educacionais e Explicativos">
                                                <option value="Realidade Aumentada (AR) e Realidade Virtual (VR)">
                                                <option value="Animação para Jogos">
                                                <option value="Produção Audiovisual para Redes Sociais">
                                                <option value="Sound Fx">
                                                <option value="UX Motion">
                                                <option value="Modelagem de Produtos">
                                            </datalist>                                    
                                        </div>  
                                        <div class="col-12 mb-3">
                                            <label id="category_en">Categoria (Inglês)</label>
                                            <input type="text"  list="lista2" name="category_en" required id="category_en" placeholder="Informe a categoria do projecto">                                    
                                            <datalist id="lista2">
                                                <option value="2D and 3D Animation">
                                                <option value="Promotional and Advertising Videos">
                                                <option value="Motion Graphics and Data Visualization">
                                                <option value="Bumpers and Intros">
                                                <option value="Character Animation">
                                                <option value="Visual Effects (VFX)">
                                                <option value="Educational and Explainer Videos">
                                                <option value="Augmented Reality (AR) and Virtual Reality (VR)">
                                                <option value="Game Animation">
                                                <option value="Audiovisual Production for Social Media">
                                                <option value="Sound FX">
                                                <option value="UX Motion">
                                                <option value="Product Modeling">                                                    
                                            </datalist>                                    
                                        </div> 
                                        <div class="col-12 mb-3">
                                            <label id="project">Nome do projecto <span class="text-danger">*</span></label>
                                            <input type="text" name="name_project" required id="name" placeholder="Nome do projecto">
                                        </div>      
                                        <div class="col-12 mb-3">
                                            <label id="client">Nome do cliente</label>
                                            <input type="text" name="client" id="client" placeholder="Nome do cliente">
                                        </div>      
                                        <div class="col-12 mb-3">
                                            <label for="desc">Descrição do projecto</label>
                                            <textarea name="description" required id="desc" cols="30" rows="5" placeholder="Descrição do projecto"></textarea>                                            
                                        </div>
                                        <div class="col-12 mb-3">
                                            <label for="desc_en">Descrição do projecto</label>
                                            <textarea name="description_en" required id="desc_en" cols="30" rows="5" placeholder="Descrição do projecto"></textarea>                                            
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Capa do projecto <span class="text-danger">*</span></label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Selecionar a capa</label>
                                            <input type="file" hidden name="file" required id="file" class="fileInput">
                                            <input type="text" hidden name="file_type" required class="file_type">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer"></div>
                                <div class="col-lg-12 mt-3 d-flex justify-content-end">
                                    <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                </div>
                            </div>
                        </form>
                        <?php else: ?>
                        <form enctype="multipart/form-data" action="<?php echo e(route('editar-projecto', $project->idProject)); ?>" method="post" class="form">
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <div class="row">                                
                                <div class="col-6">
                                    <div class="row">
                                        <div class="col-12 mb-3">
                                            <label id="category">Categoria</label>
                                            <input type="text" value="<?php echo e($project->category); ?>" list="lista" name="category" required id="category" placeholder="Informe a categoria do projecto">                                    
                                            <datalist id="lista">
                                                <option value="Animação 2D e 3D">
                                                <option value="Vídeos Promocionais e Publicitários">
                                                <option value="Motion Graphics e Visualização de Dados">
                                                <option value="Vinhetas e Intros">
                                                <option value="Animação de Personagens">
                                                <option value="Efeitos Visuais (VFX)">
                                                <option value="Vídeos Educacionais e Explicativos">
                                                <option value="Realidade Aumentada (AR) e Realidade Virtual (VR)">
                                                <option value="Animação para Jogos">
                                                <option value="Produção Audiovisual para Redes Sociais">
                                                <option value="Sound Fx">
                                                <option value="UX Motion">
                                                <option value="Modelagem de Produtos">
                                            </datalist>                                    
                                        </div>
                                        <div class="col-12 mb-3">
                                            <label id="category_en">Categoria</label>
                                            <input type="text" value="<?php echo e($project->category_en); ?>" list="lista" name="category_en" required id="category_en" placeholder="Informe a categoria do projecto">                                    
                                            <datalist id="lista">
                                                <option value="2D and 3D Animation">
                                                <option value="Promotional and Advertising Videos">
                                                <option value="Motion Graphics and Data Visualization">
                                                <option value="Bumpers and Intros">
                                                <option value="Character Animation">
                                                <option value="Visual Effects (VFX)">
                                                <option value="Educational and Explainer Videos">
                                                <option value="Augmented Reality (AR) and Virtual Reality (VR)">
                                                <option value="Game Animation">
                                                <option value="Audiovisual Production for Social Media">
                                                <option value="Sound FX">
                                                <option value="UX Motion">
                                                <option value="Product Modeling">                                                    
                                            </datalist>                                    
                                        </div>    
                                        <div class="col-12 mb-3">
                                            <label id="project">Nome do projecto</label>
                                            <input type="text" name="name_project" value="<?php echo e($project->name_project); ?>" required id="name" placeholder="Nome do projecto">
                                        </div>    
                                        <div class="col-12 mb-3">
                                            <label id="client">Nome do cliente</label>
                                            <input type="text" name="client" id="client" value="<?php echo e($project->client); ?>" placeholder="Nome do cliente">
                                        </div>      
                                        <div class="col-12 mb-3">
                                            <label for="desc">Descrição do projecto</label>
                                            <textarea name="description" id="desc" cols="30" rows="5" placeholder="Descrição do projecto"><?php echo e($project->description_project); ?></textarea>
                                        </div>
                                        <div class="col-12 mb-3">
                                            <label for="desc_en">Descrição do projecto (Inglês)</label>
                                            <textarea name="description_en" id="desc_en" cols="30" rows="5" placeholder="Descrição do projecto"><?php echo e($project->description_project_en); ?></textarea>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Capa do projecto</label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Selecionar a capa</label>
                                            <input type="file" hidden name="file" id="file" class="fileInput">
                                            <input type="text" hidden name="file_type" class="file_type">
                                        </div>
                                        <div class="col-12 mb-3">
                                            <?php if($project->file_type == "imagem"): ?>
                                            <img src="<?php echo e(asset('storage/uploads/project_'.$project->idProject.'/'.$project->thumb)); ?>" class="img-fluid rounded-2">
                                            <?php else: ?>
                                                <video autoplay loop muted class="img-fluid rounded-2">
                                                    <source src="<?php echo e(asset('storage/uploads/project_'.$project->idProject.'/'.$project->thumb)); ?>" type="video/<?php echo e($project->extension_file); ?>">
                                                    Seu navegador não suporta vídeos HTML5.
                                                </video>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer"></div>
                                <div class="col-lg-12 mt-3 d-flex justify-content-end">
                                    <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                </div>
                            </div>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/default-admin.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kambaanimation\resources\views/admin/projects/add.blade.php ENDPATH**/ ?>