
<?php $__env->startSection('title', 'Histórico do Sistema - Kamba Animations'); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Subcrições</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">newsletter</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th scope="col">Tempo</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Data</th>
                                    <th scope="col"></th> 
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($data->count()==0): ?>
                                <tr>
                                    <td colspan="3">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-envelope"></i></h1>
                                            <h3> Não existem registos</h3>
                                        </div>
                                    </td>
                                </tr>
                                <?php else: ?>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php if((\Carbon\Carbon::parse($item->created_at)->format('Y-m-d')) == date('Y-m-d')): ?>
                                                <span class="badge text-bg-warning">Hoje</span>
                                                <?php elseif((\Carbon\Carbon::parse($item->created_at)->format('Y-m')) == date('Y-m')): ?>
                                                <span class="badge text-bg-info">Este mês</span>
                                                <?php elseif((\Carbon\Carbon::parse($item->created_at)->format('Y')) == date('Y')): ?>
                                                <span class="badge text-bg-primary">Este mês</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($item->email); ?>

                                            <td><?php if($item->status==1): ?> <span class="badge rounded-pill text-bg-success">Activo</span> <?php else: ?> <span class="badge rounded-pill text-bg-danger">Inactivo</span> <?php endif; ?>                                             
                                            <td><?php echo e($item->created_at); ?>

                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <i class="bi bi-three-dots"></i>
                                                        </button>
                                                        <ul class="dropdown-menu">
                                                            <li><a class="dropdown-item text-danger" href="#"type="button" data-bs-toggle="modal" data-bs-target="#delete<?php echo e($item->id); ?>"><i class="bi bi-trash"></i> Eliminar</a></li>
                                                        </ul>
                                                    </div>
                                                </td>
                                        </tr>
                                        <div class="modal fade" id="delete<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">                                            
                                                <div class="modal-body text-center">
                                                    <h5>Deseja eliminar esta subscrição?</h5>
                                                    <form action="<?php echo e(route('eliminar-newsletter',$item->id)); ?>" method="POST">
                                                        <?php echo method_field('DELETE'); ?>;
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="btn btn-danger">Sim</button>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                    </form>
                                                </div>
                                            </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>   
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<?php echo $__env->make('script.datatable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kambaanimation\resources\views/admin/newsletter.blade.php ENDPATH**/ ?>