
<?php $__env->startSection('title', 'Team - Kamba Animation'); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Team</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">Team</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="col col-12 d-flex justify-content-end mb-3">
            <a href="<?php echo e(route('novo.membro')); ?>" class="btn btn-success btn-sm">
                <i class="bi bi-plus-lg"></i> Novo membro
            </a>

        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body pt-3">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger mb-5">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th scope="col"></th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">Especialidade</th>
                                    <th scope="col">Estado</th>
                                    <th scope="col"></th>
                                </tr>
                            </thead>
                            <tbody class="tbody-center">
                                <?php if($data->count()==0): ?>
                                <tr>
                                    <td colspan="5">
                                        <div class="text-center p-5">
                                            <h1 style="font-size: 4rem !important;"><i class="bi bi-person"></i></h1>
                                            <h3> Não existem registos</h3>
                                        </div>
                                    </td>
                                </tr>
                                <?php else: ?>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php if($item->image == "default"): ?>
                                                <img src="<?php echo e(asset('assets/img/avatar.png')); ?>" class="rounded-5 img-thumbnail" width="50" height="50" alt="">
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/uploads/team/'.$item->image)); ?>" type="button" data-bs-toggle="modal" data-bs-target="#image<?php echo e($item->idteam); ?>" class="rounded-5 img-thumbnail" style="width: 50px !important; height: 50px !important;" alt="">
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->name); ?>

                                        <td><?php echo e($item->especiality); ?>

                                        <td>
                                            <?php if($item->status=='1'): ?>
                                                <h6><span class="badge rounded-pill text-bg-success">Activo</span></h6>                                                
                                            <?php else: ?>
                                                <h6><span class="badge rounded-pill text-bg-warning">Inactivo</span></h6>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="bi bi-three-dots"></i>
                                                </button>
                                                <ul class="dropdown-menu">                                                    
                                                    <li><a href="<?php echo e(route('editar.membro',$item->idteam)); ?>" class="dropdown-item"><i class="bi bi-pencil-square"></i> Editar</a></li>
                                                    <li><a class="dropdown-item" href="#"type="button" data-bs-toggle="modal" data-bs-target="#delete<?php echo e($item->idteam); ?>"><i class="bi bi-trash"></i> Eliminar</a></li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>

                                    <div class="modal fade" id="delete<?php echo e($item->idteam); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">                                            
                                            <div class="modal-body text-center">
                                                <h5>Deseja eliminar este membro</h5>
                                                <form action="<?php echo e(route('eliminar.membro',$item->idteam)); ?>" method="POST">
                                                    <?php echo method_field('DELETE'); ?>;
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-danger">Sim</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                </form>
                                            </div>
                                        </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="image<?php echo e($item->idteam); ?>" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
                                        <div class="modal-dialog  modal-static">
                                          <div class="modal-content">                                            
                                                <img src="<?php echo e(asset('storage/uploads/team/'.$item->image)); ?>" class="img-fluid" alt="<?php echo e($item->name); ?>">
                                          </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>                        
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<?php echo $__env->make('script.datatable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kambaanimation\resources\views/admin/team/team.blade.php ENDPATH**/ ?>