
<?php $__env->startSection('title', 'Novo projecto - Kamba Animation'); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h1>Novo membro</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('team')); ?>">Team</a></li>
                <li class="breadcrumb-item active">Novo membro</li>
            </ol>
        </nav>
    </div>
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-5">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php if(!isset($team)): ?>
                        <form enctype="multipart/form-data" action="<?php echo e(route('registar.membro')); ?>" method="post" class="form">
                            <?php echo csrf_field(); ?>
                            <div class="row">                                
                                <div class="col-6">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Fotografia <span class="text-danger">*</span></label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Selecionar uma</label>
                                            <input type="file" hidden name="file" required id="file" class="fileInput">
                                        </div>
                                        <div class="col-12 mb-3">
                                            <label id="name">Nome<span class="text-danger">*</span></label>
                                            <input type="text" name="name" required id="name" placeholder="Nome">
                                        </div>      
                                        <div class="col-12 mb-3">
                                            <label id="especiality">Especialiadade</label>
                                            <input type="text" name="especiality" id="especiality" placeholder="Especialidade">
                                        </div>                                            
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer"></div>
                                <div class="col-lg-12 mt-3">
                                    <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                </div>
                            </div>
                        </form>
                        <?php else: ?>
                        <form enctype="multipart/form-data" action="<?php echo e(route('update.membro', $team->idteam)); ?>" method="post" class="form">
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <div class="row">                                
                                <div class="col-6">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                                            <label>Fotografia</label>
                                            <label for="file" class="btn btn-light"><i class="bi bi-camera-fill"></i> Selecionar uma</label>
                                            <input type="file" hidden name="file" id="file" class="fileInput">
                                        </div>
                                        <div class="col-12 mb-3">
                                            <label id="project">Nome</label>
                                            <input type="text" name="name" value="<?php echo e($team->name); ?>" required id="name" placeholder="Nome">
                                        </div>      
                                        <div class="col-12 mb-3">
                                            <label id="especiality">Especialidade</label>
                                            <input type="text" name="especiality" id="especiality" value="<?php echo e($team->especiality); ?>" placeholder="Especialidade">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 text-center mediaContainer">
                                    <?php if($team->image == "default"): ?>
                                        <img src="<?php echo e(asset('assets/img/avatar.png')); ?>"">
                                    <?php else: ?>                                                
                                        <img src="<?php echo e(asset('storage/uploads/team/'.$team->image)); ?>">
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-12 mt-3">
                                    <button class="btn btn-success "><i class="bi bi-send"></i> Guardar</button>
                                </div>
                            </div>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/preview.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kambaanimation\resources\views/admin/team/create.blade.php ENDPATH**/ ?>