import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: [                
                'resources/assets/css/app2.css',
                'resources/assets/js/app2.js',
                'resources/assets/css/app.css',
                'resources/assets/js/app.js',
                'resources/assets/js/preview.js',
                'resources/assets/js/password.js',
                'resources/assets/js/default.js',
                'resources/assets/simple-datatables/simple-datatables.js',
                'resources/assets/simple-datatables/admin.js'
            ],
            refresh: true,
        }),
    ],
    resolve: {
        alias: {
            '@' : '/resources/assets',
            '@js' : '/resources/assets/js',
            '@css' : '/resources/assets/css',
            '@bootstrap' : '/resources/assets/bootstrap',
        }
    }
});
